/*
 * Decompiled with CFR 0.152.
 */
package tocraft.walkers.traits.impl;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import org.jetbrains.annotations.NotNull;
import tocraft.walkers.Walkers;
import tocraft.walkers.traits.ShapeTrait;

public class RiderTrait<E extends class_1309>
extends ShapeTrait<E> {
    public static final class_2960 ID = Walkers.id("rider");
    public static final MapCodec<RiderTrait<?>> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.list((Codec)class_2960.field_25139).optionalFieldOf("rideable", new ArrayList()).forGetter(o -> o.rideableTypes.stream().map(arg_0 -> Walkers.getEntityTypeRegistry().method_10221(arg_0)).toList()), (App)Codec.list((Codec)class_2960.field_25139).optionalFieldOf("rideable_tags", new ArrayList()).forGetter(o -> o.rideableTags.stream().map(class_6862::comp_327).toList())).apply((Applicative)instance, instance.stable((rideableTypeIds, rideableTagIds) -> {
        ArrayList rideableTypes = new ArrayList();
        ArrayList rideableTags = new ArrayList();
        for (class_2960 rideableTypeId : rideableTypeIds) {
            if (!Walkers.getEntityTypeRegistry().method_10250(rideableTypeId)) continue;
            rideableTypes.add((class_1299)Walkers.getEntityTypeRegistry().method_10223(rideableTypeId));
        }
        for (class_2960 rideableTagId : rideableTagIds) {
            rideableTags.add(class_6862.method_40092((class_5321)Walkers.getEntityTypeRegistry().method_30517(), (class_2960)rideableTagId));
        }
        return new RiderTrait(new ArrayList<Predicate<class_1309>>(), rideableTypes, new ArrayList<Class<? extends class_1309>>(), rideableTags);
    })));
    private final List<Predicate<class_1309>> rideablePredicates;
    private final List<class_1299<?>> rideableTypes;
    private final List<Class<? extends class_1309>> rideableClasses;
    private final List<class_6862<class_1299<?>>> rideableTags;

    public static RiderTrait<?> ofRideableType(class_1299<?> ... rideable) {
        return new RiderTrait(Stream.of(rideable).map(entry -> entity -> entity.method_5864().equals(entry)).toList());
    }

    @SafeVarargs
    public static RiderTrait<?> ofRideableClass(Class<? extends class_1309> ... rideable) {
        return new RiderTrait(Stream.of(rideable).map(entry -> entry::isInstance).toList());
    }

    public RiderTrait(@NotNull List<Predicate<class_1309>> rideablePredicates) {
        this(rideablePredicates, new ArrayList(), new ArrayList<Class<? extends class_1309>>(), new ArrayList());
    }

    public RiderTrait(@NotNull List<Predicate<class_1309>> rideablePredicates, @NotNull List<class_1299<?>> rideableTypes, @NotNull List<Class<? extends class_1309>> rideableClasses, @NotNull List<class_6862<class_1299<?>>> rideableTags) {
        this.rideablePredicates = rideablePredicates;
        this.rideableTypes = rideableTypes;
        this.rideableClasses = rideableClasses;
        this.rideableTags = rideableTags;
    }

    public boolean isRideable(class_1309 entity) {
        if (this.rideableTypes.contains(entity.method_5864())) {
            return true;
        }
        for (Class<? extends class_1309> clazz : this.rideableClasses) {
            if (!clazz.isInstance(entity)) continue;
            return true;
        }
        for (class_6862 class_68622 : this.rideableTags) {
            if (!entity.method_5864().method_20210(class_68622)) continue;
            return true;
        }
        for (Predicate predicate : this.rideablePredicates) {
            if (!predicate.test(entity)) continue;
            return true;
        }
        return false;
    }

    @Override
    public class_2960 getId() {
        return ID;
    }

    @Override
    public MapCodec<? extends ShapeTrait<?>> codec() {
        return CODEC;
    }
}

