/*
 * Decompiled with CFR 0.152.
 */
package tocraft.walkers.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2179;
import net.minecraft.class_2186;
import net.minecraft.class_2321;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_7157;
import org.jetbrains.annotations.Nullable;
import tocraft.craftedcore.event.common.CommandEvents;
import tocraft.craftedcore.patched.CCommandSourceStack;
import tocraft.craftedcore.patched.CEntity;
import tocraft.craftedcore.patched.CEntitySummonArgument;
import tocraft.craftedcore.patched.TComponent;
import tocraft.walkers.Walkers;
import tocraft.walkers.api.PlayerAbilities;
import tocraft.walkers.api.PlayerShape;
import tocraft.walkers.api.PlayerShapeChanger;
import tocraft.walkers.api.variant.ShapeType;
import tocraft.walkers.command.EntityBlacklistCommands;
import tocraft.walkers.command.PlayerBlacklistCommands;
import tocraft.walkers.impl.PlayerDataProvider;

public class WalkersCommand {
    public static void initialize() {
        CommandEvents.REGISTRATION.register((dispatcher, ctx, selection) -> WalkersCommand.register((CommandDispatcher<class_2168>)dispatcher, ctx));
    }

    private static void register(CommandDispatcher<class_2168> dispatcher, class_7157 ctx) {
        LiteralCommandNode rootNode = ((LiteralArgumentBuilder)class_2170.method_9247((String)"walkers").requires(source -> source.method_9259(2))).build();
        LiteralCommandNode remove2ndShape = ((LiteralArgumentBuilder)class_2170.method_9247((String)"remove2ndShape").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9308()).executes(context -> {
            WalkersCommand.remove2ndShape((class_2168)context.getSource(), class_2186.method_9315((CommandContext)context, (String)"player"));
            return 1;
        }))).build();
        LiteralCommandNode change2ndShape = ((LiteralArgumentBuilder)class_2170.method_9247((String)"change2ndShape").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9308()).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"shape", (ArgumentType)CEntitySummonArgument.id((class_7157)ctx)).suggests(class_2321.field_10935).executes(context -> {
            WalkersCommand.change2ndShape((class_2168)context.getSource(), class_2186.method_9315((CommandContext)context, (String)"player"), CEntitySummonArgument.getEntityTypeId((CommandContext)context, (String)"shape"), null);
            return 1;
        })).then(class_2170.method_9244((String)"nbt", (ArgumentType)class_2179.method_9284()).executes(context -> {
            class_2487 nbt = class_2179.method_9285((CommandContext)context, (String)"nbt");
            WalkersCommand.change2ndShape((class_2168)context.getSource(), class_2186.method_9315((CommandContext)context, (String)"player"), CEntitySummonArgument.getEntityTypeId((CommandContext)context, (String)"shape"), nbt);
            return 1;
        }))))).build();
        LiteralCommandNode switchShape = ((LiteralArgumentBuilder)class_2170.method_9247((String)"switchShape").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9308()).then(class_2170.method_9247((String)"normal").executes(context -> {
            WalkersCommand.switchShapeToNormal((class_2168)context.getSource(), class_2186.method_9315((CommandContext)context, (String)"player"));
            return 1;
        }))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"shape", (ArgumentType)CEntitySummonArgument.id((class_7157)ctx)).suggests(class_2321.field_10935).executes(context -> {
            WalkersCommand.switchShape((class_2168)context.getSource(), class_2186.method_9315((CommandContext)context, (String)"player"), CEntitySummonArgument.getEntityTypeId((CommandContext)context, (String)"shape"), null);
            return 1;
        })).then(class_2170.method_9244((String)"nbt", (ArgumentType)class_2179.method_9284()).executes(context -> {
            class_2487 nbt = class_2179.method_9285((CommandContext)context, (String)"nbt");
            WalkersCommand.switchShape((class_2168)context.getSource(), class_2186.method_9315((CommandContext)context, (String)"player"), CEntitySummonArgument.getEntityTypeId((CommandContext)context, (String)"shape"), nbt);
            return 1;
        }))))).build();
        LiteralCommandNode show2ndShape = ((LiteralArgumentBuilder)class_2170.method_9247((String)"show2ndShape").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(context -> WalkersCommand.show2ndShape((class_2168)context.getSource(), class_2186.method_9315((CommandContext)context, (String)"player"))))).build();
        rootNode.addChild((CommandNode)remove2ndShape);
        rootNode.addChild((CommandNode)change2ndShape);
        rootNode.addChild((CommandNode)switchShape);
        rootNode.addChild((CommandNode)show2ndShape);
        rootNode.addChild(PlayerBlacklistCommands.getRootNode());
        rootNode.addChild(EntityBlacklistCommands.getRootNode(ctx));
        dispatcher.getRoot().addChild((CommandNode)rootNode);
    }

    private static int show2ndShape(class_2168 source, class_3222 player) {
        if (((PlayerDataProvider)player).walkers$get2ndShape() != null) {
            ShapeType<?> type = ((PlayerDataProvider)player).walkers$get2ndShape();
            if (type != null) {
                CCommandSourceStack.sendSuccess((class_2168)source, (class_2561)TComponent.translatable((String)"walkers.show2ndShapeNot_positive", (Object[])new Object[]{player.method_5476(), ShapeType.createTooltipText(type.create(CEntity.level((class_1297)player), (class_1657)player))}), (boolean)false);
            }
            return 1;
        }
        CCommandSourceStack.sendSuccess((class_2168)source, (class_2561)TComponent.translatable((String)"walkers.show2ndShapeNot_failed", (Object[])new Object[]{player.method_5476()}), (boolean)false);
        return 0;
    }

    private static void remove2ndShape(class_2168 source, class_3222 player) {
        WalkersCommand.change2ndShape(player, null);
        player.method_7353((class_2561)TComponent.translatable((String)"walkers.remove_entity", (Object[])new Object[0]), true);
        CCommandSourceStack.sendSuccess((class_2168)source, (class_2561)TComponent.translatable((String)"walkers.deletion_success", (Object[])new Object[]{player.method_5476()}), (boolean)false);
    }

    private static void change2ndShape(class_2168 source, class_3222 player, class_2960 id, @Nullable class_2487 nbt) {
        ShapeType<class_1299> type = ShapeType.from((class_1299)Walkers.getEntityTypeRegistry().method_10223(id));
        class_5250 name = TComponent.translatable((String)type.getEntityType().method_5882(), (Object[])new Object[0]);
        if (nbt != null) {
            class_2487 copy = nbt.method_10553();
            copy.method_10582("id", id.toString());
            class_3218 serverWorld = source.method_9225();
            class_1297 loaded = class_1299.method_17842((class_2487)copy, (class_1937)serverWorld, it -> it);
            if (loaded instanceof class_1309) {
                class_1309 living = (class_1309)loaded;
                type = ShapeType.from(living);
                name = ShapeType.createTooltipText(living);
            }
        }
        if (((PlayerDataProvider)player).walkers$get2ndShape() != type) {
            WalkersCommand.change2ndShape(player, type);
            player.method_7353((class_2561)TComponent.translatable((String)"walkers.unlock_entity", (Object[])new Object[]{name}), false);
            CCommandSourceStack.sendSuccess((class_2168)source, (class_2561)TComponent.translatable((String)"walkers.grant_success", (Object[])new Object[]{name, player.method_5476()}), (boolean)false);
        } else {
            CCommandSourceStack.sendSuccess((class_2168)source, (class_2561)TComponent.translatable((String)"walkers.already_has", (Object[])new Object[]{player.method_5476(), name}), (boolean)false);
        }
    }

    private static void switchShape(class_2168 source, class_3222 player, class_2960 shape, @Nullable class_2487 nbt) {
        class_1297 created;
        if (nbt != null) {
            class_2487 copy = nbt.method_10553();
            copy.method_10582("id", shape.toString());
            class_3218 serverWorld = source.method_9225();
            created = class_1299.method_17842((class_2487)copy, (class_1937)serverWorld, it -> it);
        } else {
            class_1299 entity = (class_1299)Walkers.getEntityTypeRegistry().method_10223(shape);
            created = entity.method_5883(CEntity.level((class_1297)player));
        }
        if (created instanceof class_1309) {
            ((PlayerDataProvider)player).walkers$updateShapes((class_1309)created);
            CCommandSourceStack.sendSuccess((class_2168)source, (class_2561)TComponent.translatable((String)"walkers.switchShape_success", (Object[])new Object[]{player.method_5476(), TComponent.translatable((String)created.method_5864().method_5882(), (Object[])new Object[0])}), (boolean)false);
        }
    }

    private static void switchShapeToNormal(class_2168 source, class_3222 player) {
        boolean result = PlayerShape.updateShapes(player, null);
        if (result) {
            CCommandSourceStack.sendSuccess((class_2168)source, (class_2561)TComponent.translatable((String)"walkers.switchShape_human_success", (Object[])new Object[]{player.method_5476()}), (boolean)false);
        }
    }

    private static void change2ndShape(class_3222 player, ShapeType<?> newShape) {
        ((PlayerDataProvider)player).walkers$set2ndShape(newShape);
        PlayerShapeChanger.sync(player);
        PlayerAbilities.sync(player);
    }
}

