/*
 * Decompiled with CFR 0.152.
 */
package tocraft.walkers.api.data.variants;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;
import tocraft.craftedcore.patched.TComponent;
import tocraft.walkers.Walkers;
import tocraft.walkers.api.data.variants.AdvancedNBTEntries;
import tocraft.walkers.api.data.variants.NBTEntry;
import tocraft.walkers.api.variant.TypeProvider;

public class NBTTypeProvider<T extends class_1309>
extends TypeProvider<T> {
    public static final Codec<NBTTypeProvider<?>> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.optionalFieldOf("fallback", (Object)0).forGetter(NBTTypeProvider::getFallbackData), (App)Codec.INT.optionalFieldOf("range", (Object)-1).forGetter(NBTTypeProvider::getRange), (App)Codec.either((Codec)Codec.list(NBTEntry.CODEC), AdvancedNBTEntries.CODEC).fieldOf("nbt").forGetter(o -> o.nbtEntryList), (App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.STRING).optionalFieldOf("names", new HashMap()).forGetter(o -> o.nameMap)).apply((Applicative)instance, instance.stable(NBTTypeProvider::new)));
    private final int fallback;
    private final int range;
    private final Either<List<NBTEntry<?>>, AdvancedNBTEntries> nbtEntryList;
    private final Map<String, String> nameMap;

    public NBTTypeProvider(int fallback, int range, Either<List<NBTEntry<?>>, AdvancedNBTEntries> nbtEntryList, Map<String, String> nameMap) {
        this.fallback = fallback;
        this.nbtEntryList = nbtEntryList;
        this.nameMap = nameMap;
        if (range >= 0 && fallback <= range) {
            this.range = range;
        } else if (nbtEntryList.left().isPresent()) {
            switch (((NBTEntry)((List)nbtEntryList.left().get()).get(0)).nbtType().toUpperCase()) {
                case "BOOL": 
                case "BOOLEAN": {
                    this.range = 1;
                    break;
                }
                default: {
                    this.range = fallback;
                    break;
                }
            }
        } else {
            this.range = nbtEntryList.right().isPresent() ? ((AdvancedNBTEntries)nbtEntryList.right().get()).highestId() : 0;
        }
    }

    @Override
    public int getVariantData(T entity) {
        List<Integer> validData;
        class_2487 tag = new class_2487();
        entity.method_5662(tag);
        ArrayList<List<Integer>> validValues = new ArrayList<List<Integer>>();
        if (this.nbtEntryList.left().isPresent()) {
            for (NBTEntry nbtEntry : (List)this.nbtEntryList.left().get()) {
                if (!tag.method_10545(nbtEntry.nbtField())) continue;
                switch (nbtEntry.nbtType().toUpperCase()) {
                    case "BOOL": 
                    case "BOOLEAN": {
                        validValues.add(nbtEntry.getIndex(tag.method_10577(nbtEntry.nbtField())));
                        break;
                    }
                    case "STRING": {
                        validValues.add(nbtEntry.getIndex(tag.method_10558(nbtEntry.nbtField())));
                        break;
                    }
                    case "INT": 
                    case "INTEGER": {
                        validValues.add(nbtEntry.getIndex(tag.method_10550(nbtEntry.nbtField())));
                    }
                }
            }
        } else if (this.nbtEntryList.right().isPresent()) {
            validValues.add(List.of(Integer.valueOf(((AdvancedNBTEntries)this.nbtEntryList.right().get()).getData(tag))));
        }
        if (!(validData = NBTTypeProvider.getValidDataValues(validValues)).isEmpty()) {
            if (validData.size() > 1) {
                Walkers.LOGGER.error("{}: found too much valid variant ids: {} for entity: {}", new Object[]{this.getClass().getSimpleName(), validData.toArray(Integer[]::new), entity.method_5864().method_5882()});
            }
            return validData.get(0);
        }
        Walkers.LOGGER.error("{}: No Variant for entity type {} found.", (Object)this.getClass().getSimpleName(), (Object)entity.method_5864().method_5882());
        return this.getFallbackData();
    }

    @NotNull
    private static List<Integer> getValidDataValues(List<List<Integer>> validValues) {
        ArrayList<Integer> validData = new ArrayList<Integer>();
        for (List<Integer> validValue : validValues) {
            for (Integer i : validValue) {
                boolean invalid = false;
                for (List<Integer> value : validValues) {
                    if (value.contains(i)) continue;
                    invalid = true;
                    break;
                }
                if (invalid || validData.contains(i)) continue;
                validData.add(i);
            }
        }
        return validData;
    }

    @Override
    public T create(class_1299<T> type, class_1937 world, int data) {
        class_2487 tag = new class_2487();
        if (this.nbtEntryList.left().isPresent()) {
            for (NBTEntry nbtEntry : (List)this.nbtEntryList.left().get()) {
                Object value = nbtEntry.getValue(data);
                if (value instanceof Integer) {
                    Integer intValue = (Integer)value;
                    tag.method_10569(nbtEntry.nbtField(), intValue.intValue());
                    continue;
                }
                if (value instanceof String) {
                    String stringValue = (String)value;
                    tag.method_10582(nbtEntry.nbtField(), stringValue);
                    continue;
                }
                if (value instanceof Boolean) {
                    Boolean booleanValue = (Boolean)value;
                    tag.method_10556(nbtEntry.nbtField(), booleanValue.booleanValue());
                    continue;
                }
                if (value != null) continue;
                Walkers.LOGGER.error("{}: variant parameter for {} not found.", (Object)this.getClass().getSimpleName(), (Object)type.method_5882());
            }
        } else if (this.nbtEntryList.right().isPresent()) {
            ((AdvancedNBTEntries)this.nbtEntryList.right().get()).fromData(tag, data);
        }
        class_2487 compoundTag = tag.method_10553();
        compoundTag.method_10582("id", Objects.requireNonNull(Walkers.getEntityTypeRegistry().method_10221(type)).toString());
        return (T)((class_1309)class_1299.method_17842((class_2487)compoundTag, (class_1937)world, entity -> entity));
    }

    @Override
    public int getFallbackData() {
        return this.fallback;
    }

    @Override
    public int getRange() {
        return this.range;
    }

    @Override
    public class_2561 modifyText(T entity, class_5250 text) {
        if (this.nameMap.containsKey(String.valueOf(this.getVariantData(entity)))) {
            return TComponent.translatable((String)this.nameMap.get(String.valueOf(this.getVariantData(entity))), (Object[])new Object[]{text});
        }
        return text;
    }
}

