package tocraft.walkers.mixin.player;

import net.minecraft.class_1297;
import net.minecraft.class_3222;
import net.minecraft.class_3231;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import tocraft.walkers.api.PlayerShape;

@Mixin(class_3231.class)
public class PlayerTrackingMixin {

    @Shadow
    @Final
    private class_1297 entity;

    @Inject(method = "addPairing", at = @At("RETURN"))
    private void sendPairingWalkersPackets(class_3222 newlyTracked, CallbackInfo ci) {
        if (this.entity instanceof class_3222 player) {
            PlayerShape.sync(newlyTracked, player);
            PlayerShape.sync(player, newlyTracked);
        }
    }
}
