package tocraft.walkers.mixin;

import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import tocraft.walkers.Walkers;
import tocraft.walkers.api.PlayerShape;
import tocraft.walkers.traits.ShapeTrait;
import tocraft.walkers.traits.TraitRegistry;
import tocraft.walkers.traits.impl.FearedTrait;
import tocraft.walkers.traits.impl.PreyTrait;

import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1338;
import net.minecraft.class_1355;
import net.minecraft.class_1400;
import net.minecraft.class_1657;

@SuppressWarnings("DataFlowIssue")
@Mixin(class_1308.class)
public class MobHunterPreyMixin {
    @Shadow
    @Final
    protected class_1355 targetSelector;
    @Shadow
    @Final
    protected class_1355 goalSelector;

    @Inject(method = "<init>", at = @At("TAIL"))
    protected void registerCustomGoals(CallbackInfo ci) {
            // ensure hunter can attack players with a shape similar to their normal prey
            if (!Walkers.CONFIG.hunterAttackAsPreyMorphedPlayer) {
                return;
            } else {
                for (Map.Entry<ShapeTrait<?>, Predicate<class_1309>> trait : TraitRegistry.getAllRegisteredById(PreyTrait.ID).entrySet()) {
                    PreyTrait<?> preyTrait = (PreyTrait<?>) trait.getKey();

                    if (preyTrait.isHunter((class_1308) (Object) this)) {
                        targetSelector.method_6277(preyTrait.getPriority(), new class_1400<>((class_1308) (Object) this, class_1657.class, preyTrait.getRandInt(), false, false, player -> {
                            class_1309 shape = PlayerShape.getCurrentShape((class_1657) player);
                            return shape != null && trait.getValue().test(shape);
                        }));
                    }
                }
            }

        if ((Object) this instanceof class_1314 mob) {
            for (Map.Entry<ShapeTrait<?>, Predicate<class_1309>> trait : TraitRegistry.getAllRegisteredById(FearedTrait.ID).entrySet()) {
                FearedTrait<?> fearedTrait = (FearedTrait<?>) trait.getKey();

                if (fearedTrait.isFeared(mob)) {
                    goalSelector.method_6277(fearedTrait.getPriority(), new class_1338<>(mob, class_1657.class, player -> {
                        class_1309 shape = PlayerShape.getCurrentShape((class_1657) player);
                        return shape != null && trait.getValue().test(shape);
                    },
                    6.0F,
                    1.0D,
                    1.2D,
                    player -> true
                    ));
                }
            }
        }
    }
}
