package tocraft.walkers.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import tocraft.walkers.api.PlayerShape;
import tocraft.walkers.traits.ShapeTrait;
import tocraft.walkers.traits.TraitRegistry;
import tocraft.walkers.traits.impl.ImmunityTrait;

@Mixin(class_1293.class)
public class MobEffectInstanceMixin {
    @WrapOperation(method = "tick", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/effect/MobEffect;applyEffectTick(Lnet/minecraft/world/entity/LivingEntity;I)Z"))
    private boolean onApplyEffect(class_1291 effect, class_1309 livingEntity, int amplifier, Operation<Boolean> original) {
        if (livingEntity instanceof class_1657 player) {
            class_1309 shape = PlayerShape.getCurrentShape(player);
            for (ShapeTrait<class_1309> immunityTrait : TraitRegistry.get(shape, ImmunityTrait.ID)) {
                if (((ImmunityTrait<class_1309>) immunityTrait).effect.equals(effect)) {
                    return true;
                }
            }
        }
        return original.call(effect, livingEntity, amplifier);
    }
}
