package tocraft.walkers.mixin;

import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1657;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.world.entity.*;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import tocraft.walkers.api.PlayerShape;
import tocraft.walkers.impl.DimensionsRefresher;
import tocraft.walkers.traits.TraitRegistry;
import tocraft.walkers.traits.impl.HumanoidTrait;
import tocraft.walkers.traits.impl.NoPhysicsTrait;

@SuppressWarnings("ConstantConditions")
@Mixin(class_1297.class)
public abstract class EntityMixin implements DimensionsRefresher {

    @Shadow
    private class_4048 dimensions;

    @Shadow
    protected boolean firstTick;

    @Shadow
    private float eyeHeight;


    @Inject(method = "getBbWidth", at = @At("HEAD"), cancellable = true)
    private void getBbWidth(CallbackInfoReturnable<Float> cir) {
        if ((Object) this instanceof class_1657 player) {
            class_1309 shape = PlayerShape.getCurrentShape(player);

            if (shape != null) {
                cir.setReturnValue(shape.method_17681());
            }
        }
    }

    @Inject(method = "getBbHeight", at = @At("HEAD"), cancellable = true)
    private void getBbHeight(CallbackInfoReturnable<Float> cir) {
        if ((Object) this instanceof class_1657 player) {
            class_1309 shape = PlayerShape.getCurrentShape(player);

            if (shape != null) {
                cir.setReturnValue(shape.method_17682());
            }
        }
    }

    @Override
    public void shape_refreshDimensions() {
        class_4048 currentDimensions = this.dimensions;
        class_4050 entityPose = ((class_1297) (Object) this).method_18376();
        class_4048 newDimensions = ((class_1297) (Object) this).method_18377(entityPose);

        this.dimensions = newDimensions;
        this.eyeHeight = ((class_1297) (Object) this).method_18381(entityPose);

        class_238 box = ((class_1297) (Object) this).method_5829();
        //#if MC>=1205
        ((class_1297) (Object) this).method_5857(new class_238(box.field_1323, box.field_1322, box.field_1321, box.field_1323 + newDimensions.comp_2185(), box.field_1322 + newDimensions.comp_2186(), box.field_1321 + newDimensions.comp_2185()));
        //#else
        //$$ ((Entity) (Object) this).setBoundingBox(new AABB(box.minX, box.minY, box.minZ, box.minX + newDimensions.width, box.minY + newDimensions.height, box.minZ + newDimensions.width));
        //#endif

        if (!this.firstTick) {
            //#if MC>=1205
            float f = currentDimensions.comp_2185() - newDimensions.comp_2185();
            //#else
            //$$ float f = currentDimensions.width - newDimensions.width;
            //#endif
            ((class_1297) (Object) this).method_5784(class_1313.field_6308, new class_243(f, 0.0D, f));
        }
    }

    @Inject(at = @At("HEAD"), method = "getEyeHeight()F", cancellable = true)
    public void getEyeHeight(CallbackInfoReturnable<Float> cir) {
        if ((class_1297) (Object) this instanceof class_1657 player) {
            class_1309 shape = PlayerShape.getCurrentShape(player);

            if (shape != null) {
                if (((class_1297) (Object) this).method_18276() && TraitRegistry.has(shape, HumanoidTrait.ID)) {
                    cir.setReturnValue(shape.method_18381(class_4050.field_18081) * 1.27F / 1.62F);
                    return;
                }
                cir.setReturnValue(shape.method_5751());
            }
        }
    }

    @Inject(method = "fireImmune", at = @At("HEAD"), cancellable = true)
    private void fireImmune(CallbackInfoReturnable<Boolean> cir) {
        if ((Object) this instanceof class_1657 player) {
            class_1309 shape = PlayerShape.getCurrentShape(player);

            if (shape != null) {
                cir.setReturnValue(shape.method_5864().method_19946());
            }
        }
    }

    @Inject(method = "tick", at = @At("HEAD"))
    private void goThroughBlocks(CallbackInfo ci) {
        if ((Object) this instanceof class_1657 player) {
            class_1309 shape = PlayerShape.getCurrentShape(player);
            if (shape != null) {
                if (TraitRegistry.has(shape, NoPhysicsTrait.ID)) {
                    player.field_5960 = true;
                }
            }
        }
    }
}
