package tocraft.walkers.impl.variant;

import com.google.common.collect.ImmutableMap;
import net.minecraft.class_1299;
import net.minecraft.class_1453;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import tocraft.craftedcore.patched.TComponent;
import tocraft.walkers.api.variant.TypeProvider;

public class ParrotTypeProvider extends TypeProvider<class_1453> {

    private static final ImmutableMap<Integer, String> PREFIX_BY_ID = ImmutableMap
            .<Integer, String>builder()
            .put(0, "Red Blue")
            .put(1, "Blue")
            .put(2, "Green")
            .put(3, "Yellow Blue")
            .put(4, "Gray")
            .build();

    @Override
    public int getVariantData(class_1453 entity) {
        //#if MC>1182
        return entity.method_6584().method_47849();
        //#else
        //$$ return entity.getVariant();
        //#endif
    }

    @Override
    public class_1453 create(class_1299<class_1453> type, class_1937 world, int data) {
        class_1453 parrot = new class_1453(type, world);
        //#if MC>1182
        parrot.method_47848(class_1453.class_7989.method_47850(data));
        //#else
        //$$ parrot.setVariant(data);
        //#endif
        return parrot;
    }

    @Override
    public int getFallbackData() {
        return 0;
    }

    @Override
    public int getRange() {
        return 4;
    }

    @Override
    public class_2561 modifyText(class_1453 parrot, class_5250 text) {
        int variant = getVariantData(parrot);
        return TComponent.literal(PREFIX_BY_ID.containsKey(variant) ? PREFIX_BY_ID.get(variant) + " " : "").method_10852(text);
    }
}
