package tocraft.walkers.ability.impl.generic;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_1308;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_1937.class_7867;
import net.minecraft.class_2960;
//#else
//$$ import net.minecraft.world.level.Explosion;
//#endif
import tocraft.walkers.Walkers;
import tocraft.walkers.ability.GenericShapeAbility;

public class ExplosionAbility<T extends class_1308> extends GenericShapeAbility<T> {
    public static final class_2960 ID = Walkers.id("explosion");
    public static final MapCodec<ExplosionAbility<?>> CODEC = RecordCodecBuilder.mapCodec((instance) -> instance.group(
            Codec.FLOAT.optionalFieldOf("radius", 3.0f).forGetter(o -> o.radius)
    ).apply(instance, instance.stable(ExplosionAbility::new)));

    private final float radius;

    public ExplosionAbility() {
        this(3.0f);
    }

    public ExplosionAbility(float radius) {
        this.radius = radius;
    }

    @Override
    public class_2960 getId() {
        return ID;
    }

    @Override
    public MapCodec<? extends GenericShapeAbility<?>> codec() {
        return CODEC;
    }

    @Override
    public void onUse(class_1657 player, T shape, class_1937 world) {
        //#if MC>1182
        world.method_8437(player, player.method_23317(), player.method_23318(), player.method_23321(), 3.0f, class_7867.field_40888);
        //#else
        //$$ world.explode(player, player.getX(), player.getY(), player.getZ(), 3.0f, Explosion.BlockInteraction.NONE);
        //#endif
    }

    @Override
    public class_1792 getIcon() {
        return class_1802.field_8626;
    }

    @Override
    public int getDefaultCooldown() {
        return 100;
    }
}
