package tocraft.walkers.ability;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import net.minecraft.world.entity.monster.*;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1428;
import net.minecraft.class_1430;
import net.minecraft.class_1438;
import net.minecraft.class_1454;
import net.minecraft.class_1463;
import net.minecraft.class_1472;
import net.minecraft.class_1473;
import net.minecraft.class_1481;
import net.minecraft.class_1493;
import net.minecraft.class_1496;
import net.minecraft.class_1501;
import net.minecraft.class_1510;
import net.minecraft.class_1528;
import net.minecraft.class_1545;
import net.minecraft.class_1548;
import net.minecraft.class_1559;
import net.minecraft.class_1560;
import net.minecraft.class_1564;
import net.minecraft.class_1571;
import net.minecraft.class_1606;
import net.minecraft.class_1613;
import net.minecraft.class_1627;
import net.minecraft.class_1640;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1844;
import net.minecraft.class_1847;
import net.minecraft.class_2960;
import net.minecraft.class_3417;
import net.minecraft.class_3483;
import net.minecraft.class_4466;
import net.minecraft.class_5354;
import net.minecraft.class_6053;
import net.minecraft.class_6862;
import net.minecraft.class_7260;
import net.minecraft.class_8153;
import net.minecraft.class_9254;
import net.minecraft.class_9334;
import net.minecraft.world.entity.animal.*;
//#endif
//#if MC>=1205
import java.util.function.Function;
import org.jetbrains.annotations.Nullable;
import tocraft.walkers.Walkers;
import tocraft.walkers.ability.impl.generic.*;
import tocraft.walkers.ability.impl.specific.*;
import tocraft.walkers.integrations.Integrations;

import java.util.*;
import java.util.function.Predicate;

@SuppressWarnings("unused")
public class AbilityRegistry {

    private static final Map<Predicate<class_1309>, ShapeAbility<?>> specificAbilities = Collections.synchronizedMap(new LinkedHashMap<>());
    private static final Map<Predicate<class_1309>, GenericShapeAbility<?>> genericAbilities = Collections.synchronizedMap(new LinkedHashMap<>());
    private static final Map<class_2960, MapCodec<? extends GenericShapeAbility<?>>> abilityCodecById = new HashMap<>();
    private static final Map<MapCodec<? extends GenericShapeAbility<?>>, class_2960> abilityIdByCodec = new IdentityHashMap<>();

    public static void initialize() {
        // register codecs
        registerCodec(ShootFireballAbility.ID, ShootFireballAbility.CODEC);
        registerCodec(ClearEffectsAbility.ID, ClearEffectsAbility.CODEC);
        registerCodec(ExplosionAbility.ID, ExplosionAbility.CODEC);
        registerCodec(ShootDragonFireball.ID, ShootDragonFireball.CODEC);
        registerCodec(TeleportationAbility.ID, TeleportationAbility.CODEC);
        registerCodec(RandomTeleportationAbility.ID, RandomTeleportationAbility.CODEC);
        registerCodec(JumpAbility.ID, JumpAbility.CODEC);
        registerCodec(ThrowPotionsAbility.ID, ThrowPotionsAbility.CODEC);
        registerCodec(SaturateAbility.ID, SaturateAbility.CODEC);
        registerCodec(ShootSnowballAbility.ID, ShootSnowballAbility.CODEC);
        registerCodec(GetItemAbility.ID, GetItemAbility.CODEC);
    }

    public static void registerDefault() {
        // Register generic Abilities first (since the last registered ability will be the used one
        registerByPredicate(livingEntity -> livingEntity instanceof class_5354, new AngerAbility<>());
        registerByPredicate(entity -> entity.method_5864().method_20210(class_3483.field_19168), new RaidAbility<>());

        // Register 'normal' Abilities
        registerByClass(class_1496.class, new JumpAbility<>());
        registerByClass(class_1545.class, new ShootFireballAbility<>(class_1802.field_8183, false));
        // higher explosion radius when charged
        registerByPredicate(entity -> entity instanceof class_1548 && !((class_1548) entity).method_6872(), new ExplosionAbility<>());
        registerByPredicate(entity -> entity instanceof class_1548 && ((class_1548) entity).method_6872(), new ExplosionAbility<>(6));
        registerByClass(class_1510.class, new ShootDragonFireball<>());
        registerByClass(class_1560.class, new TeleportationAbility<>());
        registerByClass(class_1571.class, new ShootFireballAbility<>(class_1802.field_8814, true));
        registerByClass(class_1473.class, new ShootSnowballAbility<>());
        registerByClass(class_1528.class, new WitherAbility<>());
        registerByClass(class_1430.class, new ClearEffectsAbility<>());
        registerByClass(class_6053.class, new ClearEffectsAbility<>());
        registerByClass(class_1559.class, new RandomTeleportationAbility<>());
        registerByClass(class_1501.class, new LlamaAbility<>());
        registerByClass(class_1640.class, new ThrowPotionsAbility<>());
        registerByClass(class_1564.class, new EvokerAbility<>());
        //#if MC>1182
        registerByClass(class_7260.class, new WardenAbility<>());
        //#endif
        registerByClass(class_1493.class, new AngerAbility<>(class_3417.field_14922, class_3417.field_14575));
        registerByClass(class_1472.class, new SheepAbility<>());
        //#if MC>1194
        registerByClass(class_8153.class, new SnifferAbility<>());
        //#endif
        registerByClass(class_1428.class, new ChickenAbility<>());
        registerByClass(class_1438.class, new SaturateAbility<>());
        registerByClass(class_4466.class, new AngerAbility<>(class_3417.field_20605, class_3417.field_20604));
        registerByClass(class_1606.class, new ShulkerAbility<>());
        registerByClass(class_1454.class, new PufferfishAbility<>());
        registerByClass(class_1481.class, new TurtleAbility<>());
        registerByClass(class_1463.class, new RabbitAbility<>());
        // get item ability
        registerByClass(class_1613.class, new GetItemAbility<>(new class_1799(class_1802.field_8107, 4)));
        class_1799 slownessArrows = new class_1799(class_1802.field_8087, 4);
        class_1799 poisonedArrows = new class_1799(class_1802.field_8087, 4);
        //#if MC>=1205
        slownessArrows.method_57379(class_9334.field_49651, new class_1844(class_1847.field_8996));
        poisonedArrows.method_57379(class_9334.field_49651, new class_1844(class_1847.field_8982));
        registerByClass(class_9254.class, new GetItemAbility<>(poisonedArrows));
        //#else
        //$$ PotionUtils.setPotion(slownessArrows, Potions.SLOWNESS);
        //$$ PotionUtils.setPotion(poisonedArrows, Potions.POISON);
        //#endif
        registerByClass(class_1627.class, new GetItemAbility<>(slownessArrows));

        // handle Integrations
        Integrations.registerAbilities();

        for (GenericShapeAbility<?> ability : genericAbilities.values()) {
            if (!abilityCodecById.containsKey(ability.getId())) {
                Walkers.LOGGER.warn("{} isn't registered!", ability.getId());
            }
            if (ability.getId() == null || ability.codec() == null) {
                Walkers.LOGGER.warn("{} isn't correctly setup!", ability.getClass().getSimpleName());
            }
        }
    }

    /**
     * @return the last registered {@link ShapeAbility} for the specified shape
     */
    @SuppressWarnings("unchecked")
    public static <L extends class_1309> ShapeAbility<L> get(L shape) {
        // check ability blacklist
        if (Walkers.CONFIG.abilityBlacklist.contains(class_1299.method_5890(shape.method_5864()).toString()))
            return null;

        // cache the ability so the latest registered can be used
        ShapeAbility<L> ability = null;
        for (Map.Entry<Predicate<class_1309>, ShapeAbility<?>> entry : specificAbilities.entrySet()) {
            if (entry.getKey().test(shape)) {
                ability = (ShapeAbility<L>) entry.getValue();
                // don't break so it'll access the last registered ability
            }
        }
        for (Map.Entry<Predicate<class_1309>, GenericShapeAbility<?>> entry : genericAbilities.entrySet()) {
            if (entry.getKey().test(shape)) {
                ability = (ShapeAbility<L>) entry.getValue();
                // don't break so it'll access the last registered ability
            }
        }

        return ability;
    }

    public static <A extends class_1309> void registerByType(class_1299<A> type, ShapeAbility<A> ability) {
        registerByPredicate(livingEntity -> type.equals(livingEntity.method_5864()), ability);
    }

    public static void registerByTag(class_6862<class_1299<?>> entityTag, ShapeAbility<class_1309> ability) {
        registerByPredicate(livingEntity -> livingEntity.method_5864().method_20210(entityTag), ability);
    }

    public static <A extends class_1309> void registerByClass(Class<A> entityClass, ShapeAbility<A> ability) {
        registerByPredicate(entityClass::isInstance, ability);
    }

    /**
     * Register an ability for a predicate
     *
     * @param entityPredicate this should only be true, if the entity is the correct class for the ability!
     * @param ability         your {@link ShapeAbility}
     */
    public static void registerByPredicate(Predicate<class_1309> entityPredicate, ShapeAbility<?> ability) {
        if (ability instanceof GenericShapeAbility<?> genericShapeAbility) {
            genericAbilities.put(entityPredicate, genericShapeAbility);
        } else {
            specificAbilities.put(entityPredicate, ability);
        }
    }

    public static <L extends class_1309> boolean has(L shape) {
        // check ability blacklist

        if (Walkers.CONFIG.abilityBlacklist.contains(class_1299.method_5890(shape.method_5864()).toString()))
            return false;
        return specificAbilities.keySet().stream().anyMatch(predicate -> predicate.test(shape)) || genericAbilities.keySet().stream().anyMatch(predicate -> predicate.test(shape));
    }

    public static void clearAll() {
        specificAbilities.clear();
        genericAbilities.clear();
    }

    public static void registerCodec(class_2960 abilityId, MapCodec<? extends GenericShapeAbility<?>> abilityCodec) {
        abilityCodecById.put(abilityId, abilityCodec);
        abilityIdByCodec.put(abilityCodec, abilityId);
    }

    @Nullable
    public static MapCodec<? extends GenericShapeAbility<?>> getAbilityCodec(class_2960 abilityId) {
        return abilityCodecById.get(abilityId);
    }

    @Nullable
    public static class_2960 getAbilityId(MapCodec<? extends GenericShapeAbility<?>> traitCodec) {
        return abilityIdByCodec.get(traitCodec);
    }

    public static Codec<GenericShapeAbility<?>> getAbilityCodec() {
        Codec<MapCodec<? extends GenericShapeAbility<?>>> codec = class_2960.field_25139.flatXmap(
                resourceLocation -> Optional.ofNullable(AbilityRegistry.getAbilityCodec(resourceLocation))
                        .map(DataResult::success)
                        .orElseGet(() -> Walkers.dataError("Unknown shape ability: " + resourceLocation)),
                abilityCodec -> Optional.ofNullable(getAbilityId(abilityCodec))
                        .map(DataResult::success)
                        .orElseGet(() -> Walkers.dataError("Unknown shape ability codec: " + abilityCodec))
        );
        //#if MC>=1205
        return codec.dispatchStable(GenericShapeAbility::codec, Function.identity());
        //#else
        //$$ return codec.dispatchStable(GenericShapeAbility::codec, MapCodec::codec);
        //#endif
    }
}
