/*
 * Decompiled with CFR 0.152.
 */
package tocraft.walkers.integrations.impl;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;
import tocraft.walkers.Walkers;
import tocraft.walkers.api.FlightHelper;
import tocraft.walkers.integrations.AbstractIntegration;

public class PlayerAbilityLibIntegration
extends AbstractIntegration {
    public static final String MODID = "playerabilitylib";
    @Nullable
    private final Object FLYING_MORPH_SOURCE = this.getAbilitySource(Walkers.id("flying_morph"));
    @Nullable
    private final Object ALLOW_FLIGHT_ABILITY = this.getVanillaFlightAbility();

    @Override
    public void initialize() {
        FlightHelper.GRANT.register(player -> {
            boolean bool = this.grantFlight(player);
            return bool ? class_1269.field_5812 : class_1269.field_5811;
        });
        FlightHelper.REVOKE.register(player -> {
            boolean bool = this.revokeFlight(player);
            return bool ? class_1269.field_5812 : class_1269.field_5811;
        });
    }

    @Nullable
    private Object getAbilitySource(class_2960 id) {
        try {
            Class<?> palClass = Class.forName("io.github.ladysnake.pal.Pal");
            Method getAbilitySource = palClass.getDeclaredMethod("getAbilitySource", class_2960.class);
            return getAbilitySource.invoke(null, id);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            PlayerAbilityLibIntegration.error(e);
            return null;
        }
    }

    @Nullable
    private Object getVanillaFlightAbility() {
        try {
            Class<?> vanillaAbilitiesClass = Class.forName("io.github.ladysnake.pal.VanillaAbilities");
            Field ALLOW_FLYING = vanillaAbilitiesClass.getDeclaredField("ALLOW_FLYING");
            return ALLOW_FLYING.get(null);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException e) {
            PlayerAbilityLibIntegration.error(e);
            return null;
        }
    }

    private boolean grantFlight(class_3222 player) {
        if (this.FLYING_MORPH_SOURCE != null && this.ALLOW_FLIGHT_ABILITY != null) {
            try {
                Class<?> palClass = Class.forName("io.github.ladysnake.pal.Pal");
                Method grantAbility = palClass.getDeclaredMethod("grantAbility", class_1657.class, this.ALLOW_FLIGHT_ABILITY.getClass(), this.FLYING_MORPH_SOURCE.getClass());
                grantAbility.invoke(null, player, this.ALLOW_FLIGHT_ABILITY, this.FLYING_MORPH_SOURCE);
                return true;
            }
            catch (ReflectiveOperationException e) {
                PlayerAbilityLibIntegration.error(e);
            }
        }
        return false;
    }

    private boolean revokeFlight(class_3222 player) {
        if (this.FLYING_MORPH_SOURCE != null && this.ALLOW_FLIGHT_ABILITY != null) {
            try {
                Class<?> palClass = Class.forName("io.github.ladysnake.pal.Pal");
                Method revokeAbility = palClass.getDeclaredMethod("revokeAbility", class_1657.class, this.ALLOW_FLIGHT_ABILITY.getClass(), this.FLYING_MORPH_SOURCE.getClass());
                revokeAbility.invoke(null, player, this.ALLOW_FLIGHT_ABILITY, this.FLYING_MORPH_SOURCE);
                return true;
            }
            catch (ReflectiveOperationException e) {
                PlayerAbilityLibIntegration.error(e);
            }
        }
        return false;
    }

    private static void error(Throwable e) {
        Walkers.LOGGER.error("{} couldn't succeed, there was probably an API change in the PlayerAbilityLib. Please report this!", PlayerAbilityLibIntegration.class, (Object)e);
    }
}

