/*
 * Decompiled with CFR 0.152.
 */
package tocraft.walkers.traits.impl;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7922;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.jetbrains.annotations.NotNull;
import tocraft.walkers.Walkers;
import tocraft.walkers.traits.ShapeTrait;

public class PreyTrait<E extends class_1309>
extends ShapeTrait<E> {
    public static final class_2960 ID = Walkers.id("prey");
    public static final MapCodec<PreyTrait<?>> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.list((Codec)class_2960.field_25139).optionalFieldOf("hunter", new ArrayList()).forGetter(o -> o.hunterTypes.stream().map(arg_0 -> ((class_7922)class_7923.field_41177).method_10221(arg_0)).toList()), (App)Codec.list((Codec)class_2960.field_25139).optionalFieldOf("hunter_tags", new ArrayList()).forGetter(o -> o.hunterTags.stream().map(class_6862::comp_327).toList())).apply((Applicative)instance, instance.stable((hunterLocations, hunterTagLocations) -> {
        ArrayList hunterTypes = new ArrayList();
        ArrayList hunterTags = new ArrayList();
        for (class_2960 resourceLocation : hunterLocations) {
            if (!class_7923.field_41177.method_10250(resourceLocation)) continue;
            hunterTypes.add((class_1299)class_7923.field_41177.method_10223(resourceLocation));
        }
        for (class_2960 hunterTagLocation : hunterTagLocations) {
            hunterTags.add(class_6862.method_40092((class_5321)class_7924.field_41266, (class_2960)hunterTagLocation));
        }
        return new PreyTrait(new ArrayList<Predicate<class_1309>>(), hunterTypes, new ArrayList<Class<? extends class_1309>>(), hunterTags);
    })));
    private final List<Predicate<class_1309>> hunterPredicates;
    private final List<class_1299<?>> hunterTypes;
    private final List<Class<? extends class_1309>> hunterClasses;
    private final List<class_6862<class_1299<?>>> hunterTags;

    public static PreyTrait<?> ofHunterType(class_1299<?> ... hunter) {
        return new PreyTrait(new ArrayList<Predicate<class_1309>>(), List.of(hunter), new ArrayList<Class<? extends class_1309>>(), new ArrayList());
    }

    @SafeVarargs
    public static PreyTrait<?> ofHunterTag(class_6862<class_1299<?>> ... hunter) {
        return new PreyTrait(new ArrayList<Predicate<class_1309>>(), new ArrayList(), new ArrayList<Class<? extends class_1309>>(), List.of(hunter));
    }

    @SafeVarargs
    public static PreyTrait<?> ofHunterClass(Class<? extends class_1309> ... hunter) {
        return new PreyTrait(new ArrayList<Predicate<class_1309>>(), new ArrayList(), List.of(hunter), new ArrayList());
    }

    public PreyTrait(@NotNull List<Predicate<class_1309>> hunterPredicates) {
        this(hunterPredicates, new ArrayList(), new ArrayList<Class<? extends class_1309>>(), new ArrayList());
    }

    public PreyTrait(@NotNull List<Predicate<class_1309>> hunterPredicates, @NotNull List<class_1299<?>> hunterTypes, @NotNull List<Class<? extends class_1309>> hunterClasses, @NotNull List<class_6862<class_1299<?>>> hunterTags) {
        this.hunterPredicates = hunterPredicates;
        this.hunterTypes = hunterTypes;
        this.hunterClasses = hunterClasses;
        this.hunterTags = hunterTags;
    }

    public boolean isHunter(class_1309 entity) {
        if (this.hunterTypes.contains(entity.method_5864())) {
            return true;
        }
        for (Class<? extends class_1309> clazz : this.hunterClasses) {
            if (!clazz.isInstance(entity)) continue;
            return true;
        }
        for (class_6862 class_68622 : this.hunterTags) {
            if (!entity.method_5864().method_20210(class_68622)) continue;
            return true;
        }
        for (Predicate predicate : this.hunterPredicates) {
            if (!predicate.test(entity)) continue;
            return true;
        }
        return false;
    }

    @Override
    public class_2960 getId() {
        return ID;
    }

    @Override
    public MapCodec<? extends ShapeTrait<?>> codec() {
        return CODEC;
    }
}

