/*
 * Decompiled with CFR 0.152.
 */
package tocraft.walkers.network;

import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import tocraft.craftedcore.event.common.PlayerEvents;
import tocraft.craftedcore.network.ModernNetworking;
import tocraft.walkers.ability.AbilityRegistry;
import tocraft.walkers.api.PlayerAbilities;
import tocraft.walkers.api.PlayerShape;
import tocraft.walkers.network.NetworkHandler;
import tocraft.walkers.network.impl.SwapPackets;
import tocraft.walkers.network.impl.SwapVariantPackets;
import tocraft.walkers.network.impl.SyncApiLevelPackets;
import tocraft.walkers.network.impl.UnlockPackets;

public class ServerNetworking
implements NetworkHandler {
    public static void initialize() {
        SwapPackets.registerWalkersRequestPacketHandler();
        UnlockPackets.registerShapeUnlockRequestPacketHandler();
        SwapVariantPackets.registerSwapVariantPacketHandler();
        ServerNetworking.registerUseAbilityPacketHandler();
        ModernNetworking.registerType((class_2960)SHAPE_SYNC);
        ModernNetworking.registerType((class_2960)ABILITY_SYNC);
        ModernNetworking.registerType((class_2960)UNLOCK_SYNC);
        ModernNetworking.registerType((class_2960)CHANGE_VEHICLE_STATE);
        ModernNetworking.registerType((class_2960)SYNC_API_LEVEL);
        PlayerEvents.PLAYER_JOIN.register(SyncApiLevelPackets::sendSyncPacket);
    }

    private static void registerUseAbilityPacketHandler() {
        ModernNetworking.registerReceiver((ModernNetworking.Side)ModernNetworking.Side.C2S, (class_2960)USE_ABILITY, (context, packet) -> {
            class_1657 player = context.getPlayer();
            context.getPlayer().method_5682().execute(() -> {
                class_1309 shape = PlayerShape.getCurrentShape(player);
                if (shape != null && AbilityRegistry.has(shape) && PlayerAbilities.canUseAbility(player)) {
                    AbilityRegistry.get(shape).onUse(player, shape, context.getPlayer().method_37908());
                    PlayerAbilities.setCooldown(player, AbilityRegistry.get(shape).getCooldown(shape));
                    PlayerAbilities.sync((class_3222)player);
                }
            });
        });
    }
}

