/*
 * Decompiled with CFR 0.152.
 */
package tocraft.walkers.impl.tick;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_239;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3966;
import net.minecraft.class_5250;
import tocraft.craftedcore.event.client.ClientTickEvents;
import tocraft.walkers.Walkers;
import tocraft.walkers.WalkersClient;
import tocraft.walkers.ability.AbilityRegistry;
import tocraft.walkers.api.PlayerShape;
import tocraft.walkers.api.blacklist.EntityBlacklist;
import tocraft.walkers.api.platform.ApiLevel;
import tocraft.walkers.api.variant.ShapeType;
import tocraft.walkers.impl.PlayerDataProvider;
import tocraft.walkers.network.ClientNetworking;
import tocraft.walkers.network.impl.SwapPackets;
import tocraft.walkers.network.impl.SwapVariantPackets;
import tocraft.walkers.network.impl.UnlockPackets;

@Environment(value=EnvType.CLIENT)
public class KeyPressHandler
implements ClientTickEvents.Client {
    private float currentTimer = 0.0f;

    public void tick(class_310 client) {
        if (client.field_1724 != null) {
            if (WalkersClient.ABILITY_KEY.method_1436()) {
                this.handleAbilityKey(client);
            }
            if (WalkersClient.TRANSFORM_KEY.method_1436()) {
                if (ApiLevel.getCurrentLevel().canMorph) {
                    SwapPackets.sendSwapRequest();
                } else {
                    client.field_1724.method_7353((class_2561)class_2561.method_43471((String)"walkers.feature_not_available"), true);
                }
            }
            if (WalkersClient.VARIANTS_MENU_KEY.method_1436() && Walkers.CONFIG.unlockEveryVariant) {
                if (ApiLevel.getCurrentLevel().allowVariantsMenu) {
                    class_1309 shape = PlayerShape.getCurrentShape((class_1657)client.field_1724);
                    if (shape != null) {
                        ShapeType<class_1309> shapeType = ShapeType.from(shape);
                        if (WalkersClient.isRenderingVariantsMenu) {
                            SwapVariantPackets.sendSwapRequest(shapeType.getVariantData() + WalkersClient.variantOffset);
                        }
                        WalkersClient.variantOffset = 0;
                        WalkersClient.isRenderingVariantsMenu = !WalkersClient.isRenderingVariantsMenu;
                    }
                } else {
                    client.field_1724.method_7353((class_2561)class_2561.method_43471((String)"walkers.feature_not_available"), true);
                }
            }
            if (WalkersClient.isRenderingVariantsMenu && (client.field_1690.field_1842 || !Walkers.CONFIG.unlockEveryVariant || client.field_1755 != null || PlayerShape.getCurrentShape((class_1657)client.field_1724) == null)) {
                WalkersClient.isRenderingVariantsMenu = false;
            }
            if (WalkersClient.UNLOCK_KEY.method_1434()) {
                if (ApiLevel.getCurrentLevel().canUnlock) {
                    this.handleUnlockKey(client);
                } else {
                    client.field_1724.method_7353((class_2561)class_2561.method_43471((String)"walkers.feature_not_available"), true);
                }
            } else if (this.currentTimer != Walkers.CONFIG.unlockTimer) {
                this.currentTimer = Walkers.CONFIG.unlockTimer;
            }
        }
    }

    private void handleAbilityKey(class_310 client) {
        class_1309 shape = PlayerShape.getCurrentShape((class_1657)client.field_1724);
        if (shape != null && AbilityRegistry.has(shape)) {
            ClientNetworking.sendAbilityRequest();
        }
    }

    private void handleUnlockKey(class_310 client) {
        if (client.field_1724 != null && Walkers.isPlayerBlacklisted(client.field_1724.method_5667()) && Walkers.CONFIG.blacklistPreventsUnlocking) {
            client.field_1724.method_7353((class_2561)class_2561.method_43471((String)"walkers.player_blacklisted"), true);
            return;
        }
        class_239 hit = client.field_1765;
        if (client.field_1724 != null && (((PlayerDataProvider)client.field_1724).walkers$get2ndShape() == null || Walkers.CONFIG.unlockOverridesCurrentShape) && hit instanceof class_3966) {
            class_1309 living;
            ShapeType<class_1309> type;
            class_1297 entityHit = ((class_3966)hit).method_17782();
            if (entityHit instanceof class_1309 && (type = ShapeType.from(living = (class_1309)entityHit)) != null) {
                if (EntityBlacklist.isBlacklisted(type.getEntityType())) {
                    client.field_1724.method_7353((class_2561)class_2561.method_43471((String)"walkers.unlock_entity_blacklisted"), true);
                } else if (this.currentTimer <= 0.0f) {
                    UnlockPackets.sendUnlockRequest(type);
                    class_5250 name = class_2561.method_43471((String)type.getEntityType().method_5882());
                    client.field_1724.method_7353((class_2561)class_2561.method_43469((String)"walkers.unlock_entity", (Object[])new Object[]{name}), true);
                    this.currentTimer = Walkers.CONFIG.unlockTimer;
                } else {
                    client.field_1724.method_7353((class_2561)class_2561.method_43471((String)"walkers.unlock_progress"), true);
                    this.currentTimer -= 1.0f;
                }
            }
        } else {
            this.currentTimer = Walkers.CONFIG.unlockTimer;
        }
    }
}

