package tocraft.walkers.skills;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1299;
import net.minecraft.class_1307;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1311;
import net.minecraft.class_1420;
import net.minecraft.class_1428;
import net.minecraft.class_1433;
import net.minecraft.class_1439;
import net.minecraft.class_1451;
import net.minecraft.class_1453;
import net.minecraft.class_1463;
import net.minecraft.class_1472;
import net.minecraft.class_1473;
import net.minecraft.class_1480;
import net.minecraft.class_1481;
import net.minecraft.class_1493;
import net.minecraft.class_1496;
import net.minecraft.class_1510;
import net.minecraft.class_1528;
import net.minecraft.class_1545;
import net.minecraft.class_1547;
import net.minecraft.class_1548;
import net.minecraft.class_1564;
import net.minecraft.class_1569;
import net.minecraft.class_1584;
import net.minecraft.class_1593;
import net.minecraft.class_1613;
import net.minecraft.class_1627;
import net.minecraft.class_1628;
import net.minecraft.class_1634;
import net.minecraft.class_1642;
import net.minecraft.class_2246;
import net.minecraft.class_2960;
import net.minecraft.class_3483;
import net.minecraft.class_3486;
import net.minecraft.class_3701;
import net.minecraft.class_4019;
import net.minecraft.class_4466;
import net.minecraft.class_4985;
import net.minecraft.class_6862;
import net.minecraft.class_7298;
import net.minecraft.class_7924;
import net.minecraft.world.entity.*;
import net.minecraft.world.entity.animal.*;
import net.minecraft.world.entity.monster.*;
import org.jetbrains.annotations.Nullable;
import tocraft.walkers.Walkers;
import tocraft.walkers.ability.ShapeAbility;
import tocraft.walkers.integrations.Integrations;
import tocraft.walkers.skills.impl.*;

import java.util.*;
import java.util.function.Function;
import java.util.function.Predicate;

@SuppressWarnings("unused")
public class SkillRegistry {
    private static final Map<Predicate<class_1309>, List<ShapeSkill<?>>> skillsByPredicates = new HashMap<>();
    private static final Map<class_1299<? extends class_1309>, List<ShapeSkill<?>>> skillsByEntityTypes = new HashMap<>();
    private static final Map<class_6862<class_1299<?>>, List<ShapeSkill<?>>> skillsByEntityTags = new HashMap<>();
    private static final Map<Class<? extends class_1309>, List<ShapeSkill<?>>> skillsByEntityClasses = new HashMap<>();
    private static final Map<class_2960, Codec<? extends ShapeSkill<?>>> skillCodecById = new HashMap<>();
    private static final Map<Codec<? extends ShapeSkill<?>>, class_2960> skillIdByCodec = new IdentityHashMap<>();

    public static void initialize() {
        // register skill codecs
        registerCodec(MobEffectSkill.ID, MobEffectSkill.CODEC);
        registerCodec(BurnInDaylightSkill.ID, BurnInDaylightSkill.CODEC);
        registerCodec(FlyingSkill.ID, FlyingSkill.CODEC);
        registerCodec(PreySkill.ID, PreySkill.CODEC);
        registerCodec(TemperatureSkill.ID, TemperatureSkill.CODEC);
        registerCodec(RiderSkill.ID, RiderSkill.CODEC);
        registerCodec(StandOnFluidSkill.ID, StandOnFluidSkill.CODEC);
        registerCodec(NoPhysicsSkill.ID, NoPhysicsSkill.CODEC);
        registerCodec(CantSwimSkill.ID, CantSwimSkill.CODEC);
        registerCodec(UndrownableSkill.ID, UndrownableSkill.CODEC);
        registerCodec(SlowFallingSkill.ID, SlowFallingSkill.CODEC);
        registerCodec(FearedSkill.ID, FearedSkill.CODEC);
        registerCodec(ClimbBlocksSkill.ID, ClimbBlocksSkill.CODEC);
        registerCodec(ReinforcementsSkill.ID, ReinforcementsSkill.CODEC);
        registerCodec(InstantDieOnDamageMsgSkill.ID, InstantDieOnDamageMsgSkill.CODEC);
        registerCodec(AquaticSkill.ID, AquaticSkill.CODEC);
        registerCodec(WalkOnPowderSnow.ID, WalkOnPowderSnow.CODEC);
        registerCodec(HumanoidSkill.ID, HumanoidSkill.CODEC);
        registerCodec(AttackForHealthSkill.ID, AttackForHealthSkill.CODEC);
        registerCodec(NocturnalSkill.ID, NocturnalSkill.CODEC);
    }

    @SuppressWarnings("unchecked")
    public static void registerDefault() {
        // register skills
        // mob effects
        registerByClass(class_1420.class, new MobEffectSkill<>(new class_1293(class_1294.field_5925, 100000, 0, false, false)));
        // burn in daylight
        registerByClass(class_1642.class, new BurnInDaylightSkill<>());
        registerByClass(class_1613.class, new BurnInDaylightSkill<>());
        registerByClass(class_1627.class, new BurnInDaylightSkill<>());
        registerByClass(class_1593.class, new BurnInDaylightSkill<>());
        // flying
        registerByClass(class_7298.class, new FlyingSkill<>());
        registerByClass(class_1420.class, new FlyingSkill<>());
        registerByClass(class_4466.class, new FlyingSkill<>());
        registerByClass(class_1545.class, new FlyingSkill<>());
        registerByClass(class_1510.class, new FlyingSkill<>());
        registerByClass(class_1307.class, new FlyingSkill<>());
        registerByClass(class_1453.class, new FlyingSkill<>());
        registerByClass(class_1634.class, new FlyingSkill<>());
        registerByClass(class_1528.class, new FlyingSkill<>());
        // wolf prey
        registerByClass(class_1420.class, (PreySkill<class_1420>) PreySkill.ofHunterClass(class_1493.class));
        registerByClass(class_4019.class, (PreySkill<class_4019>) PreySkill.ofHunterClass(class_1493.class));
        registerByClass(class_1472.class, (PreySkill<class_1472>) PreySkill.ofHunterClass(class_1493.class));
        registerByClass(class_1613.class, (PreySkill<class_1613>) PreySkill.ofHunterClass(class_1493.class));
        registerByClass(class_1453.class, (PreySkill<class_1453>) PreySkill.ofHunterClass(class_1493.class));
        registerByClass(class_1463.class, (PreySkill<class_1463>) PreySkill.ofHunterClass(class_1493.class));
        // fox prey
        registerByClass(class_1428.class, (PreySkill<class_1428>) PreySkill.ofHunterClass(class_4019.class));
        registerByClass(class_1463.class, (PreySkill<class_1463>) PreySkill.ofHunterClass(class_4019.class));
        registerByPredicate(entity -> entity instanceof class_1481 && entity.method_6109(), PreySkill.ofHunterClass(class_4019.class));
        // ocelot prey
        registerByClass(class_1428.class, (PreySkill<class_1428>) PreySkill.ofHunterClass(class_3701.class));
        // hostile attacked by iron golem
        registerByPredicate(entity -> entity instanceof class_1569 && !(entity instanceof class_1548), PreySkill.ofHunterClass(class_1439.class));
        // hurt by high temperature
        registerByClass(class_1473.class, new TemperatureSkill<>());
        // ravager riding
        registerByTag(class_3483.field_19168, (RiderSkill<class_1564>) RiderSkill.ofRideableClass(class_1584.class));
        registerByClass(class_1613.class, (RiderSkill<class_1613>) RiderSkill.ofRideableClass(class_1628.class));
        // Zombie Horse and Skeleton Horse riding
        registerByPredicate(entity -> entity instanceof class_1569, new RiderSkill<>(List.of(rideable -> rideable instanceof class_1496 && rideable instanceof class_1569)));
        // lava walking
        registerByClass(class_4985.class, new StandOnFluidSkill<>(class_3486.field_15518));
        // fall through blocks
        registerByClass(class_1634.class, new NoPhysicsSkill<>());
        // can't swim
        registerByClass(class_1439.class, new CantSwimSkill<>());
        // undrownable
        registerByClass(class_1439.class, new UndrownableSkill<>());
        // feared
        registerByClass(class_1493.class, (FearedSkill<class_1493>) FearedSkill.ofFearfulClass(class_1547.class));
        registerByPredicate(entity -> entity instanceof class_3701 || entity instanceof class_1451, FearedSkill.ofFearfulClass(class_1548.class));
        registerByClass(class_3701.class, (FearedSkill<class_3701>) FearedSkill.ofFearfulClass(class_1428.class));
        // climb blocks
        registerByClass(class_1628.class, new ClimbBlocksSkill<>());
        registerByClass(class_1628.class, new ClimbBlocksSkill<>(List.of(class_2246.field_10343), new ArrayList<>()));
        // reinforcements
        registerByClass(class_1493.class, new ReinforcementsSkill<>());
        registerByClass(class_4466.class, new ReinforcementsSkill<>());
        registerByTag(class_3483.field_19168, new ReinforcementsSkill<>(32, new ArrayList<>(), List.of(class_3483.field_19168)));
        // instant die on lightning
        registerByClass(class_1481.class, new InstantDieOnDamageMsgSkill<>("lightningBolt"));
        // cats hunt rabbits
        registerByClass(class_1463.class, new PreySkill<>(List.of(entity -> entity instanceof class_1451 cat && !cat.method_6181())));
        // aquatic
        registerByPredicate(entity -> entity instanceof class_1308 mob && mob.method_5864().method_5891().method_6133().contains("water") && mob instanceof class_1480, new AquaticSkill<>(0));
        registerByPredicate(entity -> entity instanceof class_1308 mob && mob.method_5864().method_5891().method_6133().contains("water") && !(mob instanceof class_1480), new AquaticSkill<>(1));
        // dolphin don't like sun
        registerByClass(class_1433.class, new BurnInDaylightSkill<>());
        // walk on powder snow
        registerByClass(class_1463.class, new WalkOnPowderSnow<>());
        // slow falling
        registerByClass(class_1428.class, new SlowFallingSkill<>());
        // support deprecated entity tags
        registerByTag(class_6862.method_40092(class_7924.field_41266, Walkers.id("burns_in_daylight")), new BurnInDaylightSkill<>());
        registerByTag(class_6862.method_40092(class_7924.field_41266, Walkers.id("flying")), new FlyingSkill<>(false));
        registerByTag(class_6862.method_40092(class_7924.field_41266, Walkers.id("slow_falling")), new SlowFallingSkill<>());
        registerByTag(class_6862.method_40092(class_7924.field_41266, Walkers.id("wolf_prey")), PreySkill.ofHunterClass(class_1493.class));
        registerByTag(class_6862.method_40092(class_7924.field_41266, Walkers.id("fox_prey")), PreySkill.ofHunterClass(class_4019.class));
        registerByTag(class_6862.method_40092(class_7924.field_41266, Walkers.id("hurt_by_high_temperature")), new TemperatureSkill<>());
        registerByTag(class_6862.method_40092(class_7924.field_41266, Walkers.id("ravager_riding")), RiderSkill.ofRideableClass(class_1584.class));
        registerByTag(class_6862.method_40092(class_7924.field_41266, Walkers.id("lava_walking")), new StandOnFluidSkill<>(class_3486.field_15518));
        registerByTag(class_6862.method_40092(class_7924.field_41266, Walkers.id("fall_through_blocks")), new NoPhysicsSkill<>());
        registerByTag(class_6862.method_40092(class_7924.field_41266, Walkers.id("cant_swim")), new CantSwimSkill<>());
        registerByTag(class_6862.method_40092(class_7924.field_41266, Walkers.id("undrownable")), new UndrownableSkill<>());
        // Attack for Health
        registerByPredicate(entity -> entity.method_5864().method_5891().equals(class_1311.field_6302), new AttackForHealthSkill<>());
        // nocturnal
        registerByPredicate(entity -> entity.method_5864().method_5891().equals(class_1311.field_6302), new NocturnalSkill<>());

        // handle Integrations
        Integrations.registerSkills();
    }

    /**
     * @return a list of every available skill for the specified entity
     */
    @SuppressWarnings("unchecked")
    public static synchronized <L extends class_1309> List<ShapeSkill<L>> getAll(L shape) {
        List<ShapeSkill<L>> skills = new ArrayList<>();
        if (shape != null) {
            if (skillsByEntityTypes.containsKey(shape.method_5864())) {
                skills.addAll(skillsByEntityTypes.get(shape.method_5864()).stream().map(skill -> (ShapeSkill<L>) skill).toList());
            }
            for (Class<? extends class_1309> aClass : skillsByEntityClasses.keySet()) {
                if (aClass.isInstance(shape))
                    skills.addAll(skillsByEntityClasses.get(aClass).stream().map(skill -> (ShapeSkill<L>) skill).toList());
            }
            for (class_6862<class_1299<?>> entityTypeTagKey : skillsByEntityTags.keySet()) {
                if (shape.method_5864().method_20210(entityTypeTagKey)) {
                    skills.addAll(skillsByEntityTags.get(entityTypeTagKey).stream().map(skill -> (ShapeSkill<L>) skill).toList());
                }
            }
            for (Predicate<class_1309> predicate : skillsByPredicates.keySet()) {
                if (predicate.test(shape)) {
                    skills.addAll(skillsByPredicates.get(predicate).stream().map(skill -> (ShapeSkill<L>) skill).toList());
                }
            }
        }
        return skills;
    }

    /**
     * @return a list of every available skill for the specified entity
     */
    public static synchronized <L extends class_1309> List<ShapeSkill<L>> get(L shape, class_2960 skillId) {
        List<ShapeSkill<L>> skills = getAll(shape);
        List<ShapeSkill<L>> filteredSkills = new ArrayList<>();
        for (ShapeSkill<L> skill : skills) {
            if (skill.getId() == skillId) {
                filteredSkills.add(skill);
            }
        }
        return filteredSkills;
    }

    public static <A extends class_1309> void registerByType(class_1299<A> type, ShapeSkill<A> skill) {
        registerByType(type, List.of(skill));
    }

    public static <A extends class_1309> void registerByType(class_1299<A> type, List<ShapeSkill<A>> newSkills) {
        List<ShapeSkill<?>> skills = skillsByEntityTypes.containsKey(type) ? skillsByEntityTypes.get(type) : new ArrayList<>();
        for (ShapeSkill<A> skill : newSkills) {
            if (skill.canBeRegisteredMultipleTimes() || skills.stream().noneMatch(entry -> entry.getId().equals(skill.getId()))) {
                skills.add(skill);
            }
        }
        skillsByEntityTypes.put(type, skills);
    }

    public static <A extends class_1309> void registerByTag(class_6862<class_1299<?>> tag, ShapeSkill<A> skill) {
        registerByTag(tag, List.of(skill));
    }

    public static <A extends class_1309> void registerByTag(class_6862<class_1299<?>> tag, List<ShapeSkill<A>> newSkills) {
        List<ShapeSkill<?>> skills = skillsByEntityTags.containsKey(tag) ? skillsByEntityTags.get(tag) : new ArrayList<>();
        for (ShapeSkill<A> skill : newSkills) {
            if (skill.canBeRegisteredMultipleTimes() || skills.stream().noneMatch(entry -> entry.getId().equals(skill.getId()))) {
                skills.add(skill);
            }
        }
        skillsByEntityTags.put(tag, skills);
    }

    public static <A extends class_1309> void registerByClass(Class<A> entityClass, ShapeSkill<A> skill) {
        registerByClass(entityClass, List.of(skill));
    }

    public static <A extends class_1309> void registerByClass(Class<A> entityClass, List<ShapeSkill<A>> newSkills) {
        List<ShapeSkill<?>> skills = skillsByEntityClasses.containsKey(entityClass) ? skillsByEntityClasses.get(entityClass) : new ArrayList<>();
        for (ShapeSkill<A> skill : newSkills) {
            if (skill.canBeRegisteredMultipleTimes() || skills.stream().noneMatch(entry -> entry.getId().equals(skill.getId()))) {
                skills.add(skill);
            }
        }
        skillsByEntityClasses.put(entityClass, skills);
    }

    /**
     * Register a skill for a predicate
     *
     * @param entityPredicate this should only be true, if the entity is the correct class for the ability!
     * @param skill           your {@link ShapeAbility}
     */
    public static void registerByPredicate(Predicate<class_1309> entityPredicate, ShapeSkill<?> skill) {
        registerByPredicate(entityPredicate, List.of(skill));
    }

    public static void registerByPredicate(Predicate<class_1309> entityPredicate, List<ShapeSkill<?>> newSkills) {
        List<ShapeSkill<?>> skills = skillsByPredicates.containsKey(entityPredicate) ? skillsByPredicates.get(entityPredicate) : new ArrayList<>();
        for (ShapeSkill<?> skill : newSkills) {
            if (skill.canBeRegisteredMultipleTimes() || skills.stream().noneMatch(entry -> entry.getId().equals(skill.getId()))) {
                skills.add(skill);
            }
        }
        skillsByPredicates.put(entityPredicate, skills);
    }

    public static void registerCodec(class_2960 skillId, Codec<? extends ShapeSkill<?>> skillCodec) {
        skillCodecById.put(skillId, skillCodec);
        skillIdByCodec.put(skillCodec, skillId);
    }

    @Nullable
    public static Codec<? extends ShapeSkill<?>> getSkillCodec(class_2960 skillId) {
        return skillCodecById.get(skillId);
    }

    @Nullable
    public static class_2960 getSkillId(Codec<? extends ShapeSkill<?>> skillCodec) {
        return skillIdByCodec.get(skillCodec);
    }

    public static <L extends class_1309> boolean has(L shape, class_2960 skillId) {
        if (shape != null) {
            if (skillsByEntityTypes.containsKey(shape.method_5864()) && skillsByEntityTypes.get(shape.method_5864()).stream().anyMatch(skill -> skill.getId() == skillId)) {
                return true;
            }
            for (Class<? extends class_1309> aClass : skillsByEntityClasses.keySet()) {
                if (aClass.isInstance(shape) && skillsByEntityClasses.get(aClass).stream().anyMatch(skill -> skill.getId() == skillId)) {
                    return true;
                }
            }
            for (class_6862<class_1299<?>> entityTypeTagKey : skillsByEntityTags.keySet()) {
                if (shape.method_5864().method_20210(entityTypeTagKey) && skillsByEntityTags.get(entityTypeTagKey).stream().anyMatch(skill -> skill.getId() == skillId)) {
                    return true;
                }
            }
            for (Predicate<class_1309> predicate : skillsByPredicates.keySet()) {
                if (predicate.test(shape) && skillsByPredicates.get(predicate).stream().anyMatch(skill -> skill.getId() == skillId)) {
                    return true;
                }
            }
        }
        return false;
    }

    public static void clearAll() {
        skillsByEntityTypes.clear();
        skillsByEntityClasses.clear();
        skillsByEntityTags.clear();
        skillsByPredicates.clear();
    }

    public static Codec<ShapeSkill<?>> getSkillCodec() {
        Codec<Codec<? extends ShapeSkill<?>>> codec = class_2960.field_25139.flatXmap(
                resourceLocation -> Optional.ofNullable(SkillRegistry.getSkillCodec(resourceLocation))
                        .map(DataResult::success)
                        .orElseGet(() -> DataResult.error(() -> "Unknown shape skill: " + resourceLocation)),
                skillCodec -> Optional.ofNullable(getSkillId(skillCodec))
                        .map(DataResult::success)
                        .orElseGet(() -> DataResult.error(() -> "Unknown shape skill codec: " + skillCodec))
        );
        return codec.dispatchStable(ShapeSkill::codec, Function.identity());
    }
}
