package tocraft.walkers.screen.hud;

import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_490;
import net.minecraft.class_7923;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import tocraft.walkers.Walkers;
import tocraft.walkers.WalkersClient;
import tocraft.walkers.api.PlayerShape;
import tocraft.walkers.api.variant.ShapeType;
import tocraft.walkers.api.variant.TypeProvider;
import tocraft.walkers.api.variant.TypeProviderRegistry;

public class VariantMenu {
    public void render(class_332 guiGraphics) {
        class_310 minecraft = class_310.method_1551();
        if (!minecraft.field_1690.field_1842 && WalkersClient.isRenderingVariantsMenu && Walkers.CONFIG.unlockEveryVariant && minecraft.field_1755 == null) {
            class_1937 level = minecraft.field_1687;
            if (level != null && minecraft.field_1724 != null) {
                ShapeType<?> currentShapeType = ShapeType.from(PlayerShape.getCurrentShape(minecraft.field_1724));
                if (currentShapeType != null) {
                    boolean hasSpecialVariant = Walkers.hasSpecialShape(minecraft.field_1724.method_5667()) && class_7923.field_41177.method_10221(currentShapeType.getEntityType()).equals(new class_2960("minecraft:wolf"));

                    int currentVariantId = currentShapeType.getVariantData();

                    // get range of variants
                    TypeProvider<?> typeProvider = TypeProviderRegistry.getProvider(currentShapeType.getEntityType());
                    int range = typeProvider != null ? typeProvider.getRange() : -1;
                    // add special shape as extra variant
                    if (hasSpecialVariant) {
                        range++;
                        class_1309 currentShape = PlayerShape.getCurrentShape(minecraft.field_1724);
                        if (currentShape != null) {
                            class_2487 nbt = new class_2487();
                            currentShape.method_5647(nbt);
                            if (nbt.method_10545("isSpecial") && nbt.method_10577("isSpecial")) {
                                currentVariantId = range;
                            }
                        }
                    }

                    // get data of menu
                    int x = guiGraphics.method_51421() / 7;
                    int y = guiGraphics.method_51443() / 5;
                    // render transparent background
                    guiGraphics.method_25296(x, 0, x * 6, y + 10, -1072689136, -804253680);
                    // render entities
                    if (range > -1) {
                        WalkersClient.variantOffset = class_3532.method_15340(WalkersClient.variantOffset, -currentVariantId - (hasSpecialVariant ? 1 : 0), range - currentVariantId);
                        for (int i = 1; i <= 5; i++) {
                            int thisVariantId = currentVariantId - 3 + i + WalkersClient.variantOffset;
                            class_1309 entity = null;
                            // special shape is rendered as an extra variant
                            if (hasSpecialVariant && thisVariantId == range) {
                                class_2487 nbt = new class_2487();

                                nbt.method_10556("isSpecial", true);
                                nbt.method_10582("id", class_7923.field_41177.method_10221(currentShapeType.getEntityType()).toString());
                                entity = (class_1309) class_1299.method_17842(nbt, level, it -> it);
                            } else if ((thisVariantId > -1 || (hasSpecialVariant && thisVariantId == -1)) && (thisVariantId <= range || thisVariantId == currentVariantId)) {
                                ShapeType<?> thisShapeType = ShapeType.from(currentShapeType.getEntityType(), thisVariantId);
                                if (thisShapeType != null) {
                                    entity = thisShapeType.create(level, minecraft.field_1724);
                                }
                            }
                            if (entity != null) {
                                class_490.method_48472(guiGraphics, (float) x * i + (float) x / 2, (float) y * .75f, (int) (25 * (1 / (Math.max(entity.method_17682(), entity.method_17681())))), new Vector3f(), new Quaternionf().rotationXYZ(0.43633232F, (float) Math.PI, (float) Math.PI), null, entity);
                            }
                        }
                    } else {
                        class_1309 entity = currentShapeType.create(level);
                        if (entity != null) {
                            class_490.method_48472(guiGraphics, (float) x * 3 + (float) x / 2, (float) y * .75f, (int) (25 * (1 / (Math.max(entity.method_17682(), entity.method_17681())))), new Vector3f(), new Quaternionf().rotationXYZ(0.43633232F, (float) Math.PI, (float) Math.PI), null, entity);
                        }
                    }
                    // render focus
                    guiGraphics.method_25293(Walkers.id("textures/gui/focused.png"), x * 3, 5, x, y, 0, 0, 48, 32, 48, 32);
                }
            }
        }
    }
}
