package tocraft.walkers.screen.hud;

import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_332;
import net.minecraft.class_3486;
import org.jetbrains.annotations.Nullable;
import tocraft.craftedcore.event.client.RenderEvents;
import tocraft.walkers.Walkers;
import tocraft.walkers.api.PlayerShape;
import tocraft.walkers.skills.SkillRegistry;
import tocraft.walkers.skills.impl.AttackForHealthSkill;
import tocraft.walkers.skills.impl.UndrownableSkill;

public class OverlayEventHandler {
    public static void initialize() {
        RenderEvents.RENDER_HEALTH.register(new RenderHealth());
        RenderEvents.RENDER_FOOD.register(new RenderFood());
    }

    private static class RenderHealth implements RenderEvents.OverlayRendering {
        @Override
        public class_1269 render(@Nullable class_332 graphics, class_1657 player) {
            if (player != null) {
                class_1309 shape = PlayerShape.getCurrentShape(player);

                if (shape != null) {
                    if (Walkers.isAquatic(shape) < 2 || SkillRegistry.has(shape, UndrownableSkill.ID) && player.method_5777(class_3486.field_15517)) {
                        return class_1269.field_5814;
                    }
                }
            }

            return class_1269.field_5811;
        }
    }

    private static class RenderFood implements RenderEvents.OverlayRendering {
        @Override
        public class_1269 render(@Nullable class_332 graphics, class_1657 player) {
            if (player != null) {
                class_1309 shape = PlayerShape.getCurrentShape(player);

                if (shape != null) {
                    if (SkillRegistry.has(shape, AttackForHealthSkill.ID)) {
                        return class_1269.field_5814;
                    }
                }
            }

            return class_1269.field_5811;
        }
    }
}
