package tocraft.walkers.registry;

import net.minecraft.class_1267;
import net.minecraft.class_1269;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1496;
import net.minecraft.class_1588;
import net.minecraft.class_1641;
import net.minecraft.class_1642;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_2509;
import net.minecraft.class_3730;
import net.minecraft.class_5425;
import net.minecraft.class_7923;
import tocraft.craftedcore.event.common.EntityEvents;
import tocraft.craftedcore.event.common.ServerLevelEvents;
import tocraft.walkers.Walkers;
import tocraft.walkers.api.PlayerHostility;
import tocraft.walkers.api.PlayerShape;
import tocraft.walkers.skills.SkillRegistry;
import tocraft.walkers.skills.impl.RiderSkill;

public class WalkersEventHandlers {

    public static void initialize() {
        registerHostilityUpdateHandler();
        registerEntityRidingHandler();
        registerPlayerRidingHandler();
        registerLivingDeathHandler();
        registerHandlerForDeprecatedEntityTags();
    }

    @SuppressWarnings({"deprecation"})
    public static void registerHandlerForDeprecatedEntityTags() {
        ServerLevelEvents.LEVEL_LOAD.register((serverLevel) -> {
            for (class_1299<?> entityType : class_7923.field_41177) {
                // print warnings for deprecated entity tags
                if (entityType.method_20210(WalkersEntityTags.BURNS_IN_DAYLIGHT)) {
                    Walkers.LOGGER.warn("Woodwalkers Warning: Please merge to the new skills system. Found " + WalkersEntityTags.BURNS_IN_DAYLIGHT + " for " + entityType);
                }
                if (entityType.method_20210(WalkersEntityTags.FLYING)) {
                    Walkers.LOGGER.warn("Woodwalkers Warning: Please merge to the new skills system. Found " + WalkersEntityTags.FLYING + " for " + entityType);
                }
                if (entityType.method_20210(WalkersEntityTags.SLOW_FALLING)) {
                    Walkers.LOGGER.warn("Woodwalkers Warning: Please merge to the new skills system. Found " + WalkersEntityTags.SLOW_FALLING + " for " + entityType);
                }
                if (entityType.method_20210(WalkersEntityTags.WOLF_PREY)) {
                    Walkers.LOGGER.warn("Woodwalkers Warning: Please merge to the new skills system. Found " + WalkersEntityTags.WOLF_PREY + " for " + entityType);
                }
                if (entityType.method_20210(WalkersEntityTags.FOX_PREY)) {
                    Walkers.LOGGER.warn("Woodwalkers Warning: Please merge to the new skills system. Found " + WalkersEntityTags.FOX_PREY + " for " + entityType);
                }
                if (entityType.method_20210(WalkersEntityTags.HURT_BY_HIGH_TEMPERATURE)) {
                    Walkers.LOGGER.warn("Woodwalkers Warning: Please merge to the new skills system. Found " + WalkersEntityTags.HURT_BY_HIGH_TEMPERATURE + " for " + entityType);
                }
                if (entityType.method_20210(WalkersEntityTags.RAVAGER_RIDING)) {
                    Walkers.LOGGER.warn("Woodwalkers Warning: Please merge to the new skills system. Found " + WalkersEntityTags.RAVAGER_RIDING + " for " + entityType);
                }
                if (entityType.method_20210(WalkersEntityTags.LAVA_WALKING)) {
                    Walkers.LOGGER.warn("Woodwalkers Warning: Please merge to the new skills system. Found " + WalkersEntityTags.LAVA_WALKING + " for " + entityType);
                }
                if (entityType.method_20210(WalkersEntityTags.FALL_THROUGH_BLOCKS)) {
                    Walkers.LOGGER.warn("Woodwalkers Warning: Please merge to the new skills system. Found " + WalkersEntityTags.FALL_THROUGH_BLOCKS + " for " + entityType);
                }
                if (entityType.method_20210(WalkersEntityTags.CANT_SWIM)) {
                    Walkers.LOGGER.warn("Woodwalkers Warning: Please merge to the new skills system. Found " + WalkersEntityTags.CANT_SWIM + " for " + entityType);
                }
                if (entityType.method_20210(WalkersEntityTags.UNDROWNABLE)) {
                    Walkers.LOGGER.warn("Woodwalkers Warning: Please merge to the new skills system. Found " + WalkersEntityTags.UNDROWNABLE + " for " + entityType);
                }
                if (entityType.method_20210(WalkersEntityTags.BLACKLISTED)) {
                    Walkers.LOGGER.warn("Woodwalkers Warning: Please merge to the new skills system. Found " + WalkersEntityTags.BLACKLISTED + " for " + entityType);
                }
            }
        });
    }

    public static void registerHostilityUpdateHandler() {
        EntityEvents.INTERACT_WITH_PLAYER.register((player, entity, hand) -> {
            if (!player.method_37908().field_9236 && Walkers.CONFIG.playerCanTriggerHostiles && entity instanceof class_1588) {
                PlayerHostility.set(player, Walkers.CONFIG.hostilityTime);
            }

            return class_1269.field_5811;
        });
    }

    // Players with an equipped Walkers inside the `ravager_riding` entity tag
    // should
    // be able to ride Ravagers.
    public static void registerEntityRidingHandler() {
        EntityEvents.INTERACT_WITH_PLAYER.register((player, entity, hand) -> {
            class_1309 shape = PlayerShape.getCurrentShape(player);
            if (shape != null && entity instanceof class_1309 livingEntity) {
                // checks, if selected entity is rideable
                for (RiderSkill<?> riderSkill : SkillRegistry.get(shape, RiderSkill.ID).stream().map(entry -> (RiderSkill<?>) entry).toList()) {
                    if (riderSkill.isRideable(livingEntity) || (livingEntity instanceof class_1657 rideablePlayer && riderSkill.isRideable(PlayerShape.getCurrentShape(rideablePlayer)))) {
                        player.method_5804(entity);
                        return class_1269.field_5811;
                    }
                }
            }
            return class_1269.field_5811;
        });
    }

    // make this server-side
    public static void registerPlayerRidingHandler() {
        EntityEvents.INTERACT_WITH_PLAYER.register((player, entity, hand) -> {
            if (entity instanceof class_1657 playerToBeRidden) {
                if (PlayerShape.getCurrentShape(playerToBeRidden) instanceof class_1496) {
                    player.method_5873(playerToBeRidden, true);
                }
            }
            return class_1269.field_5811;
        });
    }

    public static void registerLivingDeathHandler() {
        EntityEvents.LIVING_DEATH.register((entity, damageSource) -> {
            if (!entity.method_37908().method_8608()) {
                if (entity instanceof class_1646 villager && damageSource.method_5529() instanceof class_1657 player && PlayerShape.getCurrentShape(player) instanceof class_1642) {
                    if (!(player.method_37908().method_8407() != class_1267.field_5807 && player.method_6051().method_43056())) {
                        class_1641 zombievillager = villager.method_29243(class_1299.field_6054, false);
                        if (zombievillager != null) {
                            zombievillager.method_5943((class_5425) player.method_37908(), player.method_37908().method_8404(zombievillager.method_24515()), class_3730.field_16468, new class_1642.class_1644(false, true), null);
                            zombievillager.method_7195(villager.method_7231());
                            zombievillager.method_21649(villager.method_21651().method_19067(class_2509.field_11560));
                            zombievillager.method_16916(villager.method_8264().method_8268());
                            zombievillager.method_19622(villager.method_19269());
                        }
                    }
                }
            }
            return class_1269.field_5811;
        });
    }
}
