package tocraft.walkers.network.impl;

import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;
import tocraft.craftedcore.network.ModernNetworking;
import tocraft.walkers.Walkers;
import tocraft.walkers.api.PlayerShape;
import tocraft.walkers.api.PlayerShapeChanger;
import tocraft.walkers.api.blacklist.EntityBlacklist;
import tocraft.walkers.api.variant.ShapeType;
import tocraft.walkers.impl.PlayerDataProvider;
import tocraft.walkers.network.ClientNetworking;
import tocraft.walkers.network.NetworkHandler;

public class UnlockPackets {

    private static final String UNLOCK_KEY = "UnlockedShape";

    public static void handleUnlockSyncPacket(ModernNetworking.Context context, class_2487 nbt) {
        if (nbt != null) {
            class_2487 idTag = nbt.method_10562(UNLOCK_KEY);

            ClientNetworking.runOrQueue(context, player -> {
                if (!idTag.method_33133())
                    ((PlayerDataProvider) player).walkers$set2ndShape(ShapeType.from(idTag));
            });
        }
    }

    /**
     * Server handles request, that 2nd shape may be changed
     */
    @SuppressWarnings({"unchecked", "ConstantConditions"})
    public static void registerShapeUnlockRequestPacketHandler() {
        ModernNetworking.registerReceiver(ModernNetworking.Side.C2S, NetworkHandler.UNLOCK_REQUEST, (context, nbt) -> {
            // check if player is blacklisted
            if (Walkers.isPlayerBlacklisted(context.getPlayer().method_5667()))
                return;

            boolean validType = nbt.method_10577("valid_type");
            if (validType) {
                class_2960 typeId = new class_2960(nbt.method_10558("type_id"));
                class_1299<? extends class_1309> entityType = (class_1299<? extends class_1309>) class_7923.field_41177.method_10223(typeId);

                int variant = nbt.method_10550("variant");

                context.getPlayer().method_5682().execute(() -> {
                    @Nullable
                    ShapeType<? extends class_1309> type = ShapeType.from(entityType, variant);
                    if (type != null && !EntityBlacklist.isBlacklisted(type.getEntityType()) && (Walkers.CONFIG.unlockOverridesCurrentShape || ((PlayerDataProvider) context.getPlayer()).walkers$get2ndShape() == null)) {
                        // set 2nd shape
                        boolean result = PlayerShapeChanger.change2ndShape((class_3222) context.getPlayer(), type);
                        // update Player
                        if (result)
                            PlayerShape.updateShapes((class_3222) context.getPlayer(),
                                    type.create(context.getPlayer().method_37908(), context.getPlayer()));
                    }
                });
            } else {
                // Swap back to player if server allows it
                context.getPlayer().method_5682().execute(() -> PlayerShape.updateShapes((class_3222) context.getPlayer(), null));
            }

            // Refresh player dimensions
            context.getPlayer().method_18382();
        });
    }

    /**
     * Server synchronizes unlocked shape with the client
     */
    public static void sendSyncPacket(class_3222 player) {
        // Serialize unlocked to tag
        class_2487 compound = new class_2487();
        class_2487 id = new class_2487();
        if (((PlayerDataProvider) player).walkers$get2ndShape() != null)
            id = ((PlayerDataProvider) player).walkers$get2ndShape().writeCompound();
        compound.method_10566(UNLOCK_KEY, id);

        // Send to client
        ModernNetworking.sendToPlayer(player, NetworkHandler.UNLOCK_SYNC, compound);
    }

    /**
     * Client requests, that server may unlock a shape
     */
    public static void sendUnlockRequest(@Nullable ShapeType<? extends class_1309> type) {
        class_2487 packet = new class_2487();

        packet.method_10556("valid_type", type != null);
        if (type != null) {
            packet.method_10582("type_id", class_1299.method_5890(type.getEntityType()).toString());
            packet.method_10569("variant", type.getVariantData());
        }

        ModernNetworking.sendToServer(ClientNetworking.UNLOCK_REQUEST, packet);
    }
}
