package tocraft.walkers.network.impl;

import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_7923;
import tocraft.craftedcore.network.ModernNetworking;
import tocraft.walkers.Walkers;
import tocraft.walkers.api.PlayerShape;
import tocraft.walkers.api.PlayerShapeChanger;
import tocraft.walkers.api.variant.ShapeType;
import tocraft.walkers.api.variant.TypeProvider;
import tocraft.walkers.api.variant.TypeProviderRegistry;
import tocraft.walkers.network.ClientNetworking;
import tocraft.walkers.network.NetworkHandler;

public class SwapVariantPackets {

    @SuppressWarnings("ConstantConditions")
    public static void registerSwapVariantPacketHandler() {
        ModernNetworking.registerReceiver(ModernNetworking.Side.C2S, NetworkHandler.VARIANT_REQUEST,
                (context, packet) -> {
                    int variantID = packet.method_10550("variant_id");
                    context.getPlayer().method_5682().execute(() -> {
                        if (Walkers.CONFIG.unlockEveryVariant) {
                            ShapeType<?> currentShapeType = ShapeType.from(PlayerShape.getCurrentShape(context.getPlayer()));

                            TypeProvider<?> typeProvider = TypeProviderRegistry.getProvider(currentShapeType.getEntityType());
                            int range = typeProvider != null ? typeProvider.getRange() : -1;

                            // switch to special shape
                            if (Walkers.hasSpecialShape(context.getPlayer().method_5667()) && class_7923.field_41177.method_10221(currentShapeType.getEntityType()).equals(new class_2960("minecraft:wolf")) && variantID == range + 1) {
                                class_1297 created;
                                class_2487 nbt = new class_2487();

                                nbt.method_10556("isSpecial", true);
                                nbt.method_10582("id", class_7923.field_41177.method_10221(currentShapeType.getEntityType()).toString());
                                created = class_1299.method_17842(nbt, context.getPlayer().method_37908(), it -> it);
                                PlayerShape.updateShapes((class_3222) context.getPlayer(), (class_1309) created);
                            }
                            // switch normally
                            else {
                                if (currentShapeType != null && currentShapeType.getVariantData() != variantID) {
                                    ShapeType<?> newShapeType = ShapeType.from(currentShapeType.getEntityType(), variantID);
                                    if (newShapeType != null) {
                                        if (PlayerShapeChanger.change2ndShape((class_3222) context.getPlayer(), newShapeType)) {
                                            class_1309 shape = newShapeType.create(context.getPlayer().method_37908(), context.getPlayer());
                                            if (shape != null) {
                                                PlayerShape.updateShapes((class_3222) context.getPlayer(), shape);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    });
                });
    }

    public static void sendSwapRequest(int variantID) {
        if (Walkers.CONFIG.unlockEveryVariant) {
            class_2487 packet = new class_2487();
            packet.method_10569("variant_id", variantID);
            ModernNetworking.sendToServer(ClientNetworking.VARIANT_REQUEST, packet);
        }
    }
}
