package tocraft.walkers.mixin;

import net.minecraft.class_1309;
import net.minecraft.class_2781;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.class_5134;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import tocraft.walkers.Walkers;
import tocraft.walkers.api.PlayerShape;
import tocraft.walkers.api.PlayerShapeChanger;
import tocraft.walkers.impl.DimensionsRefresher;

@Mixin(class_3324.class)
public class PlayerManagerMixin {

    @SuppressWarnings("ConstantConditions")
    @Inject(method = "respawn", at = @At("RETURN"))
    private void onRespawn(class_3222 player, boolean alive, CallbackInfoReturnable<class_3222> cir) {
        class_1309 shape = PlayerShape.getCurrentShape(player);

        // refresh entity hitbox dimensions after death
        ((DimensionsRefresher) player).shape_refreshDimensions();

        if (shape != null) {
            // Re-sync max health for shapes
            if (Walkers.CONFIG.scalingHealth) {
                player.method_5996(class_5134.field_23716)
                        .method_6192(Math.min(Walkers.CONFIG.maxHealth, shape.method_6063()));
                player.method_6033(player.method_6063());
            }
            // sync max health & attack damage with clients
            if ((Walkers.CONFIG.scalingHealth || Walkers.CONFIG.percentScalingHealth)) {
                player.field_13987.method_14364(new class_2781(player.method_5628(),
                        player.method_6127().method_26851()));
            }
        }

        // send sync packets
        PlayerShapeChanger.sync(player);
        PlayerShape.sync(player);
    }
}
