package tocraft.walkers.mixin;

import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1321;
import net.minecraft.class_1338;
import net.minecraft.class_1355;
import net.minecraft.class_1400;
import net.minecraft.class_1657;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import tocraft.walkers.Walkers;
import tocraft.walkers.api.PlayerShape;
import tocraft.walkers.skills.SkillRegistry;
import tocraft.walkers.skills.impl.FearedSkill;
import tocraft.walkers.skills.impl.PreySkill;

@Mixin(class_1308.class)
public class MobHunterPreyMixin {
    @Shadow
    @Final
    protected class_1355 targetSelector;
    @Shadow
    @Final
    protected class_1355 goalSelector;

    @Unique
    private boolean walkers$registeredAttackPreyGoals = false;
    @Unique
    private boolean walkers$registeredAvoidHunterGoals = false;

    @Inject(method = "tick", at = @At("HEAD"))
    public void registerGoals(CallbackInfo ci) {
        if (!walkers$registeredAttackPreyGoals) {
            // ensure hunter can attack players with a shape similar to their normal prey
            if (!Walkers.CONFIG.hunterAttackAsPreyMorphedPlayer) {
                return;
            } else {
                targetSelector.method_6277(7,
                        new class_1400<>((class_1308) (Object) this, class_1657.class, 10, false, false, player -> {
                            // hunter should ignore players that look like their prey if they have an owner,
                            // unless the config option is turned to true
                            if (!Walkers.CONFIG.ownedHunterAttackAsPreyMorphedPlayer && (class_1308) (Object) this instanceof class_1321 tamableAnimal && tamableAnimal.method_35057() != null) {
                                return false;
                            }

                            class_1309 shape = PlayerShape.getCurrentShape((class_1657) player);

                            if (shape != null) {
                                for (PreySkill<?> preySkill : SkillRegistry.get(shape, PreySkill.ID).stream().map(entry -> (PreySkill<?>) entry).toList()) {
                                    if (preySkill.isHunter((class_1308) (Object) this)) return true;
                                }
                            }

                            return false;
                        }));
            }

            walkers$registeredAttackPreyGoals = true;
        }

        if (!walkers$registeredAvoidHunterGoals && (Object) this instanceof class_1314 mob) {
            goalSelector.method_6277(3, new class_1338<>(
                    mob,
                    class_1657.class,
                    player -> {
                        class_1309 shape = PlayerShape.getCurrentShape((class_1657) player);
                        if (shape != null) {
                            for (FearedSkill<?> fearedSkill : SkillRegistry.get(shape, FearedSkill.ID).stream().map(entry -> (FearedSkill<?>) entry).toList()) {
                                if (fearedSkill.isFeared(mob)) {
                                    return true;
                                }
                            }
                        }
                        return false;

                    },
                    6.0F,
                    1.0D,
                    1.2D,
                    player -> true
            ));
            walkers$registeredAvoidHunterGoals = true;
        }
    }
}
