package tocraft.walkers.integrations.impl;

import tocraft.walkers.Walkers;
import tocraft.walkers.api.variant.TypeProvider;
import tocraft.walkers.api.variant.TypeProviderRegistry;
import tocraft.walkers.integrations.AbstractIntegration;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;

// Reflections are simply great!
public class MoreMobVariantsIntegration extends AbstractIntegration {
    public static final String MODID = "moremobvariants";

    @Override
    public void registerTypeProvider() {
        registerMMVTypeProvider(class_1299.field_16281);
        registerMMVTypeProvider(class_1299.field_6132);
        registerMMVTypeProvider(class_1299.field_6085);
        registerMMVTypeProvider(class_1299.field_6137);
        registerMMVTypeProvider(class_1299.field_6079);
        registerMMVTypeProvider(class_1299.field_6055);
        registerMMVTypeProvider(class_1299.field_6051);
    }

    private static <L extends class_1309> void registerMMVTypeProvider(class_1299<L> type) {
        TypeProviderRegistry.register(type, new MMVTypeProvider<>(type));
    }

    @SuppressWarnings("unchecked")
    private static List<class_2960> getVariants(class_1299<?> type) {
        try {
            Class<?> variantsClass = Class.forName("com.github.nyuppo.config.Variants");
            Method getVariants = variantsClass.getDeclaredMethod("getVariants", class_1299.class);
            List<Object> variants = (List<Object>) getVariants.invoke(null, type);
            List<class_2960> variantIds = new ArrayList<>();
            for (Object variant : variants) {
                class_2960 id = (class_2960) variant.getClass().getMethod("getIdentifier").invoke(variant);
                variantIds.add(id);
            }
            return variantIds;
        } catch (ClassNotFoundException | NoSuchMethodException | IllegalAccessException |
                 InvocationTargetException e) {
            Walkers.LOGGER.error("{}: failed to get the mob blacklist for {}: {}", GuardVillagersIntegration.class.getSimpleName(), MODID, e);
        }

        return new ArrayList<>();
    }

    @SuppressWarnings("unused")
    private static class MMVTypeProvider<L extends class_1309> extends TypeProvider<L> {
        private final class_1299<L> type;

        public MMVTypeProvider(class_1299<L> type) {
            this.type = type;
        }

        @Override
        public int getVariantData(L entity) {
            List<class_2960> variants = getVariants(type);
            class_2487 nbt = new class_2487();
            entity.method_5647(nbt);
            class_2960 id = new class_2960(nbt.method_10558("VariantID"));
            return variants.indexOf(id);
        }

        @SuppressWarnings("unchecked")
        @Override
        public L create(class_1299<L> type, class_1937 world, int data) {
            class_2487 nbt = new class_2487();
            nbt.method_10582("id", class_1299.method_5890(type).toString());
            class_2960 variantId = getVariants(type).get(data);
            nbt.method_10582("VariantID", variantId.toString());
            return (L) class_1299.method_17842(nbt, world, entity -> entity);
        }

        @Override
        public int getFallbackData() {
            return 0;
        }

        @Override
        public int getRange() {
            return getVariants(type).size() - 1;
        }

        @Override
        public class_2561 modifyText(L entity, class_5250 text) {
            List<class_2960> variants = getVariants(type);
            class_2487 nbt = new class_2487();
            entity.method_5647(nbt);
            class_2960 id = new class_2960(nbt.method_10558("VariantID"));
            return class_2561.method_43470(formatTypePrefix(id.method_12832()) + " ").method_10852(text);
        }
    }
}
