package tocraft.walkers.impl.variant;

import tocraft.walkers.Walkers;
import tocraft.walkers.api.variant.TypeProvider;

import java.util.Random;
import net.minecraft.class_1299;
import net.minecraft.class_1641;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_3854;
import net.minecraft.class_5250;
import net.minecraft.class_7923;

public class ZombieVillagerTypeProvider extends TypeProvider<class_1641> {

    @Override
    public int getVariantData(class_1641 entity) {
        return class_7923.field_41195.method_10206(entity.method_7231().method_16924());
    }

    @Override
    public class_1641 create(class_1299<class_1641> type, class_1937 level, int data) {
        class_1641 villager = new class_1641(type, level);
        villager.method_7195(villager.method_7231().method_16921(class_7923.field_41195.method_10200(data)));
        return villager;
    }

    @Override
    public class_1641 create(class_1299<class_1641> type, class_1937 level, int data, class_1657 player) {
        if (player != null && Walkers.CONFIG.multiVectorVariants > 0) {
            class_1641 villager = new class_1641(type, level);
            class_3854 villagerType;
            if (Walkers.CONFIG.multiVectorVariants == 2) {
                villagerType = class_3854.method_16930(level.method_23753(player.method_24515()));
            } else {
                villagerType = class_7923.field_41194.method_10200(new Random().nextInt(0, class_7923.field_41194.method_10204() - 1));
            }
            villager.method_47883(villagerType);
            villager.method_7195(villager.method_7231().method_16921(class_7923.field_41195.method_10200(data)));
            return villager;
        } else {
            return create(type, level, data);
        }
    }

    @Override
    public int getFallbackData() {
        return 0;
    }

    @Override
    public int getRange() {
        return class_7923.field_41195.method_10204() - 1;
    }

    @Override
    public class_2561 modifyText(class_1641 entity, class_5250 text) {
        return class_2561.method_43470(formatTypePrefix(entity.method_7231().method_16924().toString()) + " ").method_10852(text);
    }
}
