package tocraft.walkers.impl.variant;

import tocraft.walkers.api.variant.TypeProvider;

import java.util.Optional;
import net.minecraft.class_1299;
import net.minecraft.class_1606;
import net.minecraft.class_1767;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public class ShulkerTypeProvider extends TypeProvider<class_1606> {

    @Override
    public int getVariantData(class_1606 entity) {
        Optional<class_1767> color = entity.method_47881();
        return color.map(class_1767::method_7789).orElse(16);
    }

    @Override
    public class_1606 create(class_1299<class_1606> type, class_1937 world, int data) {
        class_1606 shulker = new class_1606(type, world);
        if (data < 16) shulker.method_47880(Optional.of(class_1767.method_7791(data)));
        return shulker;
    }

    @Override
    public int getFallbackData() {
        return 16;
    }

    @Override
    public int getRange() {
        return 16;
    }

    @Override
    public class_2561 modifyText(class_1606 entity, class_5250 text) {
        int data = getVariantData(entity);
        String prefix = data < 16 ? formatTypePrefix(class_1767.method_7791(getVariantData(entity)).method_7792()) : "Natural";
        return class_2561.method_43470(prefix + " ").method_10852(text);
    }
}
