package tocraft.walkers.fabric.mixin;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import tocraft.walkers.api.PlayerShape;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1528;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1937;

@Mixin(class_1528.class)
public abstract class WitherEntityMixin extends class_1588 {

    private WitherEntityMixin(class_1299<? extends class_1588> entityType, class_1937 world) {
        super(entityType, world);
    }

    @Inject(method = "customServerAiStep", at = @At(value = "INVOKE", target = "Ljava/util/List;isEmpty()Z"), locals = LocalCapture.CAPTURE_FAILHARD)
    private void removeInvalidPlayerTargets(CallbackInfo ci, int j, List<class_1309> list) {
        List<class_1309> toRemove = new ArrayList<>();

        list.forEach(entity -> {
            if (entity instanceof class_1657 player) {
                class_1309 shape = PlayerShape.getCurrentShape(player);

                // potentially ignore undead walkers players
                if (shape != null && shape.method_5999()) {
                    if (this.method_5968() != null) {
                        // if this wither's target is not equal to the current entity
                        if (!this.method_5968().method_5667().equals(entity.method_5667())) {
                            toRemove.add(entity);
                        }
                    } else {
                        toRemove.add(entity);
                    }
                }
            }
        });

        list.removeAll(toRemove);
    }
}
