package tocraft.walkers.fabric.mixin;

import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import tocraft.walkers.api.PlayerShape;
import tocraft.walkers.skills.SkillRegistry;
import tocraft.walkers.skills.impl.NocturnalSkill;

import java.util.List;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

@Mixin(class_3218.class)
public abstract class NocturnalServerLevelMixin {
    @Shadow
    @Final
    List<class_3222> players;

    @ModifyArg(method = "tick", at = @At(value = "INVOKE", target = "Lnet/minecraft/server/level/ServerLevel;setDayTime(J)V"))
    private long modifyIsDay(long original) {
        if (((class_1937) (Object) this).method_8530() && this.players.stream().anyMatch(player -> player.method_6113() && SkillRegistry.has(PlayerShape.getCurrentShape(player), NocturnalSkill.ID))) {
            return original + ((class_3218) (Object) this).method_8532() % 24000L > 12000L ? 13000 : -11000;
        } else {
            return original;
        }
    }
}
