package tocraft.walkers.api.data.skills;

import com.google.gson.*;
import com.mojang.serialization.Codec;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import tocraft.craftedcore.data.SynchronizedJsonReloadListener;
import tocraft.craftedcore.platform.PlatformData;
import tocraft.walkers.Walkers;
import tocraft.walkers.skills.ShapeSkill;
import tocraft.walkers.skills.SkillRegistry;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_2960;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public class SkillDataManager extends SynchronizedJsonReloadListener {
    public static final Gson GSON = new GsonBuilder().registerTypeAdapter(class_2960.class, new class_2960.class_2961()).create();

    public SkillDataManager() {
        super(GSON, Walkers.MODID + "/skills");
    }

    @SuppressWarnings("unchecked")
    @Override
    protected void onApply(Map<class_2960, JsonElement> map) {
        // prevent duplicates and the registration of removed entries
        SkillRegistry.clearAll();
        SkillRegistry.registerDefault();

        for (Map.Entry<class_2960, JsonElement> mapEntry : map.entrySet()) {
            SkillList skillList = skillListFromJson(mapEntry.getValue().getAsJsonObject());

            if (!skillList.isEmpty()) {
                if (skillList.requiredMod() == null || PlatformData.isModLoaded(skillList.requiredMod())) {
                    // entity types
                    for (class_1299<class_1309> entityType : skillList.entityTypes()) {
                        SkillRegistry.registerByType(entityType, skillList.skillList().stream().map(skill -> (ShapeSkill<class_1309>) skill).toList());
                    }

                    if (!skillList.entityTypes().isEmpty())
                        Walkers.LOGGER.info("{}: {} registered for {}", getClass().getSimpleName(), skillList.entityTypes(), skillList.skillList().stream().map(skill -> skill.getClass().getSimpleName()).toArray(String[]::new));

                    // entity tags
                    for (class_6862<class_1299<?>> entityTag : skillList.entityTags()) {
                        SkillRegistry.registerByTag(entityTag, skillList.skillList().stream().map(skill -> (ShapeSkill<class_1309>) skill).toList());
                    }

                    if (!skillList.entityTags().isEmpty())
                        Walkers.LOGGER.info("{}: {} registered for {}", getClass().getSimpleName(), skillList.entityTags(), skillList.skillList().stream().map(skill -> skill.getClass().getSimpleName()).toArray(String[]::new));
                }
            }
        }
    }

    public static Codec<SkillList> SKILL_LIST_CODEC = RecordCodecBuilder.create((instance) -> instance.group(
            Codec.STRING.optionalFieldOf("required_mod", "").forGetter(SkillList::requiredMod),
            Codec.list(class_2960.field_25139).optionalFieldOf("entity_types", new ArrayList<>()).forGetter(SkillList::entityTypeKeys),
            Codec.list(class_2960.field_25139).optionalFieldOf("entity_tags", new ArrayList<>()).forGetter(SkillList::entityTagKeys),
            Codec.list(SkillRegistry.getSkillCodec()).fieldOf("skills").forGetter(SkillList::skillList)
    ).apply(instance, instance.stable(SkillList::new)));

    protected static SkillList skillListFromJson(JsonObject json) {
        return SKILL_LIST_CODEC.parse(JsonOps.INSTANCE, json).getOrThrow(false, s -> {
            throw new JsonParseException(s);
        });
    }

    @SuppressWarnings("unused")
    public record SkillList(String requiredMod, List<class_2960> entityTypeKeys,
                            List<class_2960> entityTagKeys,
                            List<ShapeSkill<?>> skillList) {

        public SkillList(List<class_1299<?>> entityTypeKeys, List<class_6862<class_1299<?>>> entityTagKeys, List<ShapeSkill<?>> skillList, String requiredMod) {
            this(requiredMod, entityTypeKeys.stream().map(class_1299::method_5890).toList(), entityTagKeys.stream().map(class_6862::comp_327).toList(), skillList);
        }

        @SuppressWarnings("unchecked")
        public List<class_1299<class_1309>> entityTypes() {
            return entityTypeKeys.stream().filter(class_7923.field_41177::method_10250).map(type -> (class_1299<class_1309>) class_7923.field_41177.method_10223(type)).toList();
        }

        public List<class_6862<class_1299<?>>> entityTags() {
            return entityTagKeys().stream().map(tag -> class_6862.method_40092(class_7924.field_41266, tag)).toList();
        }

        public boolean isEmpty() {
            return (entityTypeKeys().isEmpty() && entityTagKeys().isEmpty()) || skillList().isEmpty();
        }
    }
}
