package tocraft.walkers.api.data.blacklist;

import com.google.gson.*;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import tocraft.craftedcore.data.SynchronizedJsonReloadListener;
import tocraft.walkers.Walkers;
import tocraft.walkers.api.blacklist.EntityBlacklist;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2960;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public class EntityBlacklistDataManager extends SynchronizedJsonReloadListener {
    public static final Gson GSON = new GsonBuilder().registerTypeAdapter(class_2960.class, new class_2960.class_2961()).create();

    public EntityBlacklistDataManager() {
        super(GSON, Walkers.MODID);
    }

    @Override
    protected void onApply(Map<class_2960, JsonElement> map) {
        // prevent duplicates and the registration of removed entries
        EntityBlacklist.clearAll();
        EntityBlacklist.registerDefault();

        for (Map.Entry<class_2960, JsonElement> mapEntry : map.entrySet()) {
            if (mapEntry.getKey().method_12832().equals("blacklist")) {
                Pair<List<class_2960>, List<class_2960>> someBlacklist = blacklistFromJson(mapEntry.getValue().getAsJsonObject());
                for (class_2960 resourceLocation : someBlacklist.getFirst()) {
                    if (class_7923.field_41177.method_10250(resourceLocation)) {
                        EntityBlacklist.registerByType(class_7923.field_41177.method_10223(resourceLocation));
                    }
                }
                for (class_2960 resourceLocation : someBlacklist.getSecond()) {
                    EntityBlacklist.registerByTag(class_6862.method_40092(class_7924.field_41266, resourceLocation));
                }
            }
        }
    }

    public static Codec<Pair<List<class_2960>, List<class_2960>>> BLACKLIST_CODEC = RecordCodecBuilder.create((instance) -> instance.group(
            Codec.list(class_2960.field_25139).optionalFieldOf("entity_types", new ArrayList<>()).forGetter(Pair::getFirst),
            Codec.list(class_2960.field_25139).optionalFieldOf("entity_tags", new ArrayList<>()).forGetter(Pair::getSecond)
    ).apply(instance, instance.stable(Pair::new)));

    protected static Pair<List<class_2960>, List<class_2960>> blacklistFromJson(JsonObject json) {
        return BLACKLIST_CODEC.parse(JsonOps.INSTANCE, json).getOrThrow(false, (s) -> {
            throw new JsonParseException(s);
        });
    }
}
