package tocraft.walkers.ability.impl;

import tocraft.walkers.ability.ShapeAbility;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1308;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_7923;

public class SnifferAbility<T extends class_1308> extends ShapeAbility<T> {

    @Override
    public void onUse(class_1657 player, T shape, class_1937 world) {
        // Ensures, the player isn't in Water/Lava and touches the ground
        if (player.method_5771() || player.method_5799() || !player.method_24828())
            return;

        class_2338 playerPos = player.method_24515();
        class_2338 blockPos = new class_2338(playerPos.method_10263(), playerPos.method_10264() - 1, playerPos.method_10260());
        List<class_2248> diggableBlocks = new ArrayList<>();
        diggableBlocks.add(class_7923.field_41175.method_10223(new class_2960("minecraft:dirt")));
        diggableBlocks.add(class_7923.field_41175.method_10223(new class_2960("minecraft:grass_block")));
        diggableBlocks.add(class_7923.field_41175.method_10223(new class_2960("minecraft:podzol")));
        diggableBlocks.add(class_7923.field_41175.method_10223(new class_2960("minecraft:rooted_dirt")));
        diggableBlocks.add(class_7923.field_41175.method_10223(new class_2960("minecraft:moss_block")));
        diggableBlocks.add(class_7923.field_41175.method_10223(new class_2960("minecraft:mud")));
        diggableBlocks.add(class_7923.field_41175.method_10223(new class_2960("minecraft:muddy_mangrove_roots")));

        // checks, if the block bellow the player is in the 'diggableBlocks'-List
        if (diggableBlocks.contains(world.method_8320(blockPos).method_26204()) && Math.random() <= 0.5D) {
            // drop Item
            if (getRandomBoolean())
                player.method_5706(class_1802.field_42711);
            else
                player.method_5706(class_1802.field_43195);

            world.method_43129(null, player, class_3417.field_42604, class_3419.field_15248, 1.0F, (world.field_9229.method_43057() - world.field_9229.method_43057()) * 0.2F + 1.0F);
        } else
            world.method_43129(null, player, class_3417.field_42605, class_3419.field_15248, 1.0F, (world.field_9229.method_43057() - world.field_9229.method_43057()) * 0.2F + 1.0F);
    }

    @Override
    public class_1792 getIcon() {
        return class_1802.field_42695;
    }

    private static boolean getRandomBoolean() {
        return Math.random() < 0.5;
    }

    @Override
    public int getDefaultCooldown() {
        return 9600;
    }
}
