package tocraft.walkers.ability;

import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1428;
import net.minecraft.class_1430;
import net.minecraft.class_1438;
import net.minecraft.class_1454;
import net.minecraft.class_1463;
import net.minecraft.class_1472;
import net.minecraft.class_1473;
import net.minecraft.class_1481;
import net.minecraft.class_1493;
import net.minecraft.class_1496;
import net.minecraft.class_1501;
import net.minecraft.class_1510;
import net.minecraft.class_1528;
import net.minecraft.class_1545;
import net.minecraft.class_1548;
import net.minecraft.class_1559;
import net.minecraft.class_1560;
import net.minecraft.class_1564;
import net.minecraft.class_1571;
import net.minecraft.class_1606;
import net.minecraft.class_1640;
import net.minecraft.class_3417;
import net.minecraft.class_3483;
import net.minecraft.class_4466;
import net.minecraft.class_5354;
import net.minecraft.class_6053;
import net.minecraft.class_7260;
import net.minecraft.class_7923;
import net.minecraft.class_8153;
import net.minecraft.world.entity.animal.*;
import net.minecraft.world.entity.monster.*;
import tocraft.walkers.Walkers;
import tocraft.walkers.ability.impl.*;
import tocraft.walkers.integrations.Integrations;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Predicate;

@SuppressWarnings("unused")
public class AbilityRegistry {

    private static final Map<Predicate<class_1309>, ShapeAbility<?>> abilities = new LinkedHashMap<>();

    public static void registerDefault() {
        // Register generic Abilities first (since the last registered ability will be the used one
        registerByPredicate(livingEntity -> livingEntity instanceof class_5354, new AngerAbility<>());
        registerByPredicate(entity -> entity.method_5864().method_20210(class_3483.field_19168), new RaidAbility<>());

        // Register 'normal' Abilities
        registerByClass(class_1496.class, new HorseAbility<>());
        registerByClass(class_1545.class, new BlazeAbility<>());
        registerByClass(class_1548.class, new CreeperAbility<>());
        registerByClass(class_1510.class, new EnderDragonAbility<>());
        registerByClass(class_1560.class, new EndermanAbility<>());
        registerByClass(class_1571.class, new GhastAbility<>());
        registerByClass(class_1473.class, new SnowGolemAbility<>());
        registerByClass(class_1528.class, new WitherAbility<>());
        registerByClass(class_1430.class, new CowAbility<>());
        registerByClass(class_6053.class, new CowAbility<>());
        registerByClass(class_1559.class, new EndermiteAbility<>());
        registerByClass(class_1501.class, new LlamaAbility<>());
        registerByClass(class_1640.class, new WitchAbility<>());
        registerByClass(class_1564.class, new EvokerAbility<>());
        registerByClass(class_7260.class, new WardenAbility<>());
        registerByClass(class_1493.class, new AngerAbility<>(class_3417.field_14922, class_3417.field_14575));
        registerByClass(class_1472.class, new SheepAbility<>());
        registerByClass(class_8153.class, new SnifferAbility<>());
        registerByClass(class_1428.class, new ChickenAbility<>());
        registerByClass(class_1438.class, new MushroomCowAbility<>());
        registerByClass(class_4466.class, new AngerAbility<>(class_3417.field_20605, class_3417.field_20604));
        registerByClass(class_1606.class, new ShulkerAbility<>());
        registerByClass(class_1454.class, new PufferfishAbility<>());
        registerByClass(class_1481.class, new TurtleAbility<>());
        registerByClass(class_1463.class, new RabbitAbility<>());

        // handle Integrations
        Integrations.registerAbilities();
    }

    /**
     * @return the last registered {@link ShapeAbility} for the specified shape
     */
    @SuppressWarnings("unchecked")
    public static <L extends class_1309> ShapeAbility<L> get(L shape) {
        // check ability blacklist
        if (Walkers.CONFIG.abilityBlacklist.contains(class_7923.field_41177.method_10221(shape.method_5864()).toString()))
            return null;

        for (Map.Entry<Predicate<class_1309>, ShapeAbility<?>> entry : abilities.entrySet()) {
            if (entry.getKey().test(shape)) {
                return (ShapeAbility<L>) entry.getValue();
            }
        }

        return null;
    }

    public static <A extends class_1309> void registerByType(class_1299<A> type, ShapeAbility<A> ability) {
        registerByPredicate(livingEntity -> type.equals(livingEntity.method_5864()), ability);
    }

    public static <A extends class_1309> void registerByClass(Class<A> entityClass, ShapeAbility<A> ability) {
        registerByPredicate(entityClass::isInstance, ability);
    }

    /**
     * Register an ability for a predicate
     *
     * @param entityPredicate this should only be true, if the entity is the correct class for the ability!
     * @param ability         your {@link ShapeAbility}
     */
    public static void registerByPredicate(Predicate<class_1309> entityPredicate, ShapeAbility<?> ability) {
        abilities.put(entityPredicate, ability);
    }

    public static <L extends class_1309> boolean has(L shape) {
        // check ability blacklist

        if (Walkers.CONFIG.abilityBlacklist.contains(class_7923.field_41177.method_10221(shape.method_5864()).toString()))
            return false;
        return abilities.keySet().stream().anyMatch(predicate -> predicate.test(shape));
    }

    public static void clearAll() {
        abilities.clear();
    }
}
