/*
 * Decompiled with CFR 0.152.
 */
package tocraft.walkers.network;

import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;
import tocraft.craftedcore.client.CraftedCoreClient;
import tocraft.craftedcore.network.client.ClientNetworking;
import tocraft.walkers.impl.DimensionsRefresher;
import tocraft.walkers.impl.PlayerDataProvider;
import tocraft.walkers.network.NetworkHandler;
import tocraft.walkers.network.impl.UnlockPackets;
import tocraft.walkers.network.impl.VehiclePackets;

public class ClientNetworking
implements NetworkHandler {
    public static void registerPacketHandlers() {
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, (class_2960)NetworkHandler.SHAPE_SYNC, ClientNetworking::handleWalkersSyncPacket);
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, (class_2960)NetworkHandler.ABILITY_SYNC, ClientNetworking::handleAbilitySyncPacket);
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, (class_2960)NetworkHandler.UNLOCK_SYNC, UnlockPackets::handleUnlockSyncPacket);
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, (class_2960)NetworkHandler.CHANGE_VEHICLE_STATE, VehiclePackets::handleSyncPacket);
    }

    public static void runOrQueue(NetworkManager.PacketContext context, ClientNetworking.ApplicablePacket packet) {
        if (context.getPlayer() == null) {
            CraftedCoreClient.getSyncPacketQueue().add(packet);
        } else {
            context.queue(() -> packet.apply(context.getPlayer()));
        }
    }

    public static void sendAbilityRequest() {
        NetworkManager.sendToServer((class_2960)USE_ABILITY, (class_2540)new class_2540(Unpooled.buffer()));
    }

    public static void handleWalkersSyncPacket(class_2540 packet, NetworkManager.PacketContext context) {
        UUID uuid = packet.method_10790();
        String id = packet.method_19772();
        class_2487 entityNbt = packet.method_10798();
        ClientNetworking.runOrQueue(context, player -> {
            @Nullable class_1657 syncTarget = player.method_5770().method_18470(uuid);
            if (syncTarget != null) {
                PlayerDataProvider data = (PlayerDataProvider)syncTarget;
                if (id.equals("minecraft:empty")) {
                    data.walkers$setCurrentShape(null);
                    ((DimensionsRefresher)syncTarget).shape_refreshDimensions();
                    return;
                }
                if (entityNbt != null) {
                    entityNbt.method_10582("id", id);
                    Optional type = class_1299.method_17684((class_2487)entityNbt);
                    if (type.isPresent()) {
                        class_1309 shape = data.walkers$getCurrentShape();
                        if (shape == null || !((class_1299)type.get()).equals(shape.method_5864())) {
                            shape = (class_1309)((class_1299)type.get()).method_5883(syncTarget.method_37908());
                            data.walkers$setCurrentShape(shape);
                            ((DimensionsRefresher)syncTarget).shape_refreshDimensions();
                        }
                        if (shape != null) {
                            shape.method_5651(entityNbt);
                        }
                    }
                }
            }
        });
    }

    public static void handleAbilitySyncPacket(class_2540 packet, NetworkManager.PacketContext context) {
        int cooldown = packet.readInt();
        ClientNetworking.runOrQueue(context, player -> ((PlayerDataProvider)player).walkers$setAbilityCooldown(cooldown));
    }
}

