/*
 * Decompiled with CFR 0.152.
 */
package tocraft.walkers.api.data.variants;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.minecraft.class_7923;
import tocraft.walkers.Walkers;
import tocraft.walkers.api.variant.TypeProvider;

public class NBTTypeProvider<T extends class_1309>
extends TypeProvider<T> {
    public static Codec<NBTTypeProvider<?>> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.optionalFieldOf("fallback", (Object)0).forGetter(NBTTypeProvider::getFallbackData), (App)Codec.INT.optionalFieldOf("range").forGetter(o -> Optional.of(o.getRange())), (App)Codec.list(NBTEntry.CODEC).fieldOf("nbt").forGetter(o -> o.nbtEntryList), (App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.STRING).optionalFieldOf("names", new HashMap()).forGetter(o -> o.nameMap)).apply((Applicative)instance, instance.stable(NBTTypeProvider::new)));
    private final int fallback;
    private final int range;
    private final List<NBTEntry<?>> nbtEntryList;
    private final Map<String, String> nameMap;

    NBTTypeProvider(int fallback, Optional<Integer> range, List<NBTEntry<?>> nbtEntryList, Map<String, String> nameMap) {
        this(fallback, range.orElseGet(() -> {
            switch (((NBTEntry)nbtEntryList.get((int)0)).nbtType.toUpperCase()) {
                case "BOOL": 
                case "BOOLEAN": {
                    return 1;
                }
            }
            return fallback;
        }), nbtEntryList, nameMap);
    }

    NBTTypeProvider(int fallback, int range, List<NBTEntry<?>> nbtEntryList, Map<String, String> nameMap) {
        this.fallback = fallback;
        this.range = range;
        this.nbtEntryList = nbtEntryList;
        this.nameMap = nameMap;
    }

    @Override
    public int getVariantData(T entity) {
        class_2487 tag = new class_2487();
        entity.method_5662(tag);
        Optional data = Optional.empty();
        for (NBTEntry<?> nbtEntry : this.nbtEntryList) {
            Optional<Object> entryData = Optional.empty();
            if (tag.method_10545(nbtEntry.nbtField())) {
                switch (nbtEntry.nbtType().toUpperCase()) {
                    case "BOOL": 
                    case "BOOLEAN": {
                        entryData = nbtEntry.getIndex(tag.method_10577(nbtEntry.nbtField()));
                        break;
                    }
                    case "STRING": {
                        entryData = nbtEntry.getIndex(tag.method_10558(nbtEntry.nbtField()));
                        break;
                    }
                    case "INT": 
                    case "INTEGER": {
                        entryData = nbtEntry.getIndex(tag.method_10550(nbtEntry.nbtField()));
                    }
                }
            }
            if (!entryData.isPresent()) continue;
            if (data.isPresent()) {
                if (!entryData.equals(data)) continue;
                return (Integer)entryData.get();
            }
            data = entryData;
        }
        if (data.isPresent()) {
            return (Integer)data.get();
        }
        Walkers.LOGGER.error("{}: parameter for the Variant not found.", (Object)this.getClass().getSimpleName());
        return this.getFallbackData();
    }

    @Override
    public T create(class_1299<T> type, class_1937 world, int data) {
        class_2487 tag = new class_2487();
        for (NBTEntry<?> nbtEntry : this.nbtEntryList) {
            Object value = nbtEntry.getValue(data);
            if (value instanceof Integer) {
                Integer intValue = (Integer)value;
                tag.method_10569(nbtEntry.nbtField(), intValue.intValue());
                continue;
            }
            if (value instanceof String) {
                String stringValue = (String)value;
                tag.method_10582(nbtEntry.nbtField(), stringValue);
                continue;
            }
            if (!(value instanceof Boolean)) continue;
            Boolean booleanValue = (Boolean)value;
            tag.method_10556(nbtEntry.nbtField(), booleanValue.booleanValue());
        }
        class_2487 compoundTag = tag.method_10553();
        compoundTag.method_10582("id", class_7923.field_41177.method_10221(type).toString());
        return (T)((class_1309)class_1299.method_17842((class_2487)compoundTag, (class_1937)world, entity -> entity));
    }

    @Override
    public int getFallbackData() {
        return this.fallback;
    }

    @Override
    public int getRange() {
        return this.range;
    }

    @Override
    public class_2561 modifyText(T entity, class_5250 text) {
        if (this.nameMap.containsKey(String.valueOf(this.getVariantData(entity)))) {
            return class_2561.method_43469((String)this.nameMap.get(String.valueOf(this.getVariantData(entity))), (Object[])new Object[]{text});
        }
        return text;
    }

    public record NBTEntry<T>(String nbtType, String nbtField, Map<Integer, T> parameterList, boolean isMutable) {
        public static Codec<NBTEntry<?>> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("nbt_type").forGetter(NBTEntry::nbtType), (App)Codec.STRING.fieldOf("nbt_field").forGetter(NBTEntry::nbtField), (App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.STRING).optionalFieldOf("parameters", new HashMap()).forGetter(o -> new HashMap()), (App)Codec.BOOL.optionalFieldOf("is_mutable", (Object)false).forGetter(NBTEntry::isMutable)).apply((Applicative)instance, instance.stable((nbtType, nbtField, parameters, isMutable) -> {
            switch (nbtType.toUpperCase()) {
                case "INT": 
                case "INTEGER": {
                    return new NBTEntry<Object>((String)nbtType, (String)nbtField, (Map<Integer, Object>)new HashMap<Integer, Object>(){
                        {
                            parameters.forEach((key, value) -> this.put(Integer.valueOf(key), Integer.valueOf(value)));
                        }
                    }, (boolean)isMutable);
                }
                case "BOOL": 
                case "BOOLEAN": {
                    return new NBTEntry<Object>((String)nbtType, (String)nbtField, (Map<Integer, Object>)new HashMap<Integer, Object>(){
                        {
                            parameters.forEach((key, value) -> this.put(Integer.valueOf(key), Boolean.valueOf(value)));
                        }
                    }, (boolean)isMutable);
                }
            }
            return new NBTEntry<Object>((String)nbtType, (String)nbtField, (Map<Integer, Object>)new HashMap<Integer, Object>(){
                {
                    parameters.forEach((key, value) -> this.put(Integer.valueOf(key), value));
                }
            }, (boolean)isMutable);
        })));

        public T getValue(int index) {
            if (!this.parameterList.isEmpty()) {
                if (this.parameterList.containsKey(index)) {
                    return this.parameterList.get(index);
                }
                Walkers.LOGGER.warn("{}: variant parameter in list not found.", (Object)this.getClass().getSimpleName());
            }
            switch (this.nbtType.toUpperCase()) {
                case "INT": 
                case "INTEGER": {
                    return (T)Integer.valueOf(index);
                }
                case "BOOL": 
                case "BOOLEAN": {
                    if (index == 1) {
                        return (T)Boolean.valueOf(true);
                    }
                    return (T)Boolean.valueOf(false);
                }
            }
            Walkers.LOGGER.error("{}: variant parameter not found.", (Object)this.getClass().getSimpleName());
            return null;
        }

        public Optional<Integer> getIndex(T value) {
            Optional<Integer> index = Optional.empty();
            if (!this.parameterList.isEmpty()) {
                class_5250 tagDataMutable;
                if (this.isMutable && value instanceof String && (tagDataMutable = class_2561.class_2562.method_10873((String)((String)value))) != null) {
                    value = tagDataMutable.getString();
                }
                Object object = this.parameterList.keySet().iterator();
                while (object.hasNext()) {
                    class_5250 parameterMutable;
                    int i = (Integer)object.next();
                    Object parameterT = this.parameterList.get(i);
                    if (this.isMutable && parameterT instanceof String && (parameterMutable = class_2561.class_2562.method_10873((String)((String)parameterT))) != null) {
                        parameterT = parameterMutable.getString();
                    }
                    if (!value.equals(parameterT)) continue;
                    index = Optional.of(i);
                    break;
                }
            }
            if (index.isEmpty()) {
                switch (this.nbtType.toUpperCase()) {
                    case "BOOL": 
                    case "BOOLEAN": {
                        if (((Boolean)value).booleanValue()) {
                            index = Optional.of(1);
                            break;
                        }
                        index = Optional.of(0);
                        break;
                    }
                    case "INT": 
                    case "INTEGER": {
                        index = Optional.of((Integer)value);
                    }
                }
            }
            return index;
        }
    }
}

