/*
 * Decompiled with CFR 0.152.
 */
package tocraft.walkers.registry;

import com.mojang.serialization.DynamicOps;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.EntityEvent;
import dev.architectury.event.events.common.InteractionEvent;
import net.minecraft.class_1267;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1315;
import net.minecraft.class_1496;
import net.minecraft.class_1506;
import net.minecraft.class_1507;
import net.minecraft.class_1569;
import net.minecraft.class_1584;
import net.minecraft.class_1588;
import net.minecraft.class_1641;
import net.minecraft.class_1642;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_3730;
import net.minecraft.class_5425;
import tocraft.walkers.Walkers;
import tocraft.walkers.api.PlayerHostility;
import tocraft.walkers.api.PlayerShape;
import tocraft.walkers.impl.PlayerDataProvider;
import tocraft.walkers.registry.WalkersEntityTags;

public class WalkersEventHandlers {
    public static void initialize() {
        WalkersEventHandlers.registerHostilityUpdateHandler();
        WalkersEventHandlers.registerRavagerRidingHandler();
        WalkersEventHandlers.registerHostileHorseRidingHandler();
        WalkersEventHandlers.registerPlayerRidingHandler();
        WalkersEventHandlers.registerLivingDeathHandler();
    }

    public static void registerHostilityUpdateHandler() {
        InteractionEvent.INTERACT_ENTITY.register((player, entity, hand) -> {
            if (!player.method_37908().field_9236 && entity instanceof class_1588) {
                PlayerHostility.set(player, Walkers.CONFIG.hostilityTime);
            }
            return EventResult.pass();
        });
    }

    public static void registerRavagerRidingHandler() {
        InteractionEvent.INTERACT_ENTITY.register((player, entity, hand) -> {
            class_1309 shape;
            class_1657 targetedPlayer;
            if ((entity instanceof class_1584 || entity instanceof class_1657 && ((PlayerDataProvider)(targetedPlayer = (class_1657)entity)).walkers$getCurrentShape() instanceof class_1584) && (shape = PlayerShape.getCurrentShape(player)) != null && shape.method_5864().method_20210(WalkersEntityTags.RAVAGER_RIDING)) {
                player.method_5804(entity);
            }
            return EventResult.pass();
        });
    }

    public static void registerHostileHorseRidingHandler() {
        InteractionEvent.INTERACT_ENTITY.register((player, entity, hand) -> {
            class_1309 shape;
            if ((entity instanceof class_1506 || entity instanceof class_1507) && (shape = PlayerShape.getCurrentShape(player)) instanceof class_1569) {
                player.method_5804(entity);
            }
            return EventResult.pass();
        });
    }

    public static void registerPlayerRidingHandler() {
        InteractionEvent.INTERACT_ENTITY.register((player, entity, hand) -> {
            class_1657 playerToBeRidden;
            if (entity instanceof class_1657 && PlayerShape.getCurrentShape(playerToBeRidden = (class_1657)entity) instanceof class_1496) {
                player.method_5873((class_1297)playerToBeRidden, true);
            }
            return EventResult.pass();
        });
    }

    public static void registerLivingDeathHandler() {
        EntityEvent.LIVING_DEATH.register((entity, damageSource) -> {
            if (!entity.method_37908().method_8608() && entity instanceof class_1646) {
                class_1641 zombievillager;
                class_1657 player;
                class_1646 villager = (class_1646)entity;
                class_1297 patt3947$temp = damageSource.method_5529();
                if (patt3947$temp instanceof class_1657 && PlayerShape.getCurrentShape(player = (class_1657)patt3947$temp) instanceof class_1642 && (player.method_37908().method_8407() == class_1267.field_5807 || !player.method_6051().method_43056()) && (zombievillager = (class_1641)villager.method_29243(class_1299.field_6054, false)) != null) {
                    zombievillager.method_5943((class_5425)player.method_37908(), player.method_37908().method_8404(zombievillager.method_24515()), class_3730.field_16468, (class_1315)new class_1642.class_1644(false, true), null);
                    zombievillager.method_7195(villager.method_7231());
                    zombievillager.method_21649((class_2520)villager.method_21651().method_19067((DynamicOps)class_2509.field_11560));
                    zombievillager.method_16916(villager.method_8264().method_8268());
                    zombievillager.method_19622(villager.method_19269());
                }
            }
            return EventResult.pass();
        });
    }
}

