/*
 * Decompiled with CFR 0.152.
 */
package tocraft.walkers.mixin.player;

import dev.architectury.event.EventResult;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1324;
import net.minecraft.class_1496;
import net.minecraft.class_1584;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_5134;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import tocraft.walkers.Walkers;
import tocraft.walkers.api.FlightHelper;
import tocraft.walkers.api.PlayerShape;
import tocraft.walkers.api.event.ShapeEvents;
import tocraft.walkers.api.variant.ShapeType;
import tocraft.walkers.impl.DimensionsRefresher;
import tocraft.walkers.impl.PlayerDataProvider;
import tocraft.walkers.mixin.EntityTrackerAccessor;
import tocraft.walkers.mixin.ThreadedAnvilChunkStorageAccessor;
import tocraft.walkers.registry.WalkersEntityTags;

@Mixin(value={class_1657.class})
public abstract class PlayerEntityDataMixin
extends class_1309
implements PlayerDataProvider {
    @Unique
    private static final String ABILITY_COOLDOWN_KEY = "AbilityCooldown";
    @Unique
    private ShapeType<?> walkers$unlocked;
    @Unique
    private int walkers$remainingTime = 0;
    @Unique
    private int walkers$abilityCooldown = 0;
    @Unique
    private class_1309 walkers$shape = null;
    @Unique
    private Optional<UUID> walkers$vehiclePlayerUUID = Optional.empty();

    @Shadow
    public abstract void method_5783(class_3414 var1, float var2, float var3);

    private PlayerEntityDataMixin(class_1299<? extends class_1309> type, class_1937 world) {
        super(type, world);
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="RETURN")})
    private void readNbt(class_2487 tag, CallbackInfo info) {
        class_2487 unlockedShape = tag.method_10562("UnlockedShape");
        this.walkers$unlocked = ShapeType.from(unlockedShape);
        this.walkers$abilityCooldown = tag.method_10550(ABILITY_COOLDOWN_KEY);
        this.walkers$remainingTime = tag.method_10550("RemainingHostilityTime");
        this.walkers$readCurrentShape(tag.method_10562("CurrentShape"));
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="RETURN")})
    private void writeNbt(class_2487 tag, CallbackInfo info) {
        class_2487 id = new class_2487();
        if (this.walkers$unlocked != null) {
            id = this.walkers$unlocked.writeCompound();
        }
        tag.method_10566("UnlockedShape", (class_2520)id);
        tag.method_10569(ABILITY_COOLDOWN_KEY, this.walkers$abilityCooldown);
        tag.method_10569("RemainingHostilityTime", this.walkers$remainingTime);
        tag.method_10566("CurrentShape", (class_2520)this.walkers$writeCurrentShape(new class_2487()));
    }

    @Unique
    private class_2487 walkers$writeCurrentShape(class_2487 tag) {
        class_2487 entityTag = new class_2487();
        if (this.walkers$shape != null) {
            this.walkers$shape.method_5647(entityTag);
        }
        tag.method_10582("id", this.walkers$shape == null ? "minecraft:empty" : class_7923.field_41177.method_10221((Object)this.walkers$shape.method_5864()).toString());
        tag.method_10566("EntityData", (class_2520)entityTag);
        return tag;
    }

    @Unique
    public void walkers$readCurrentShape(class_2487 tag) {
        class_2487 entityTag;
        Optional type = class_1299.method_17684((class_2487)tag);
        if (tag.method_10558("id").equals("minecraft:empty")) {
            this.walkers$shape = null;
            ((DimensionsRefresher)((Object)this)).shape_refreshDimensions();
        } else if (type.isPresent() && !(entityTag = tag.method_10562("EntityData")).method_33133()) {
            if (this.walkers$shape == null || !((class_1299)type.get()).equals(this.walkers$shape.method_5864())) {
                this.walkers$shape = (class_1309)((class_1299)type.get()).method_5883(this.method_37908());
                ((DimensionsRefresher)((Object)this)).shape_refreshDimensions();
            }
            this.walkers$shape.method_5651(entityTag);
        }
    }

    @Override
    @Unique
    public ShapeType<?> walkers$get2ndShape() {
        return this.walkers$unlocked;
    }

    @Override
    public void walkers$set2ndShape(ShapeType<?> unlocked) {
        this.walkers$unlocked = unlocked;
    }

    @Override
    @Unique
    public int walkers$getRemainingHostilityTime() {
        return this.walkers$remainingTime;
    }

    @Override
    @Unique
    public void walkers$setRemainingHostilityTime(int max) {
        this.walkers$remainingTime = max;
    }

    @Override
    @Unique
    public int walkers$getAbilityCooldown() {
        return this.walkers$abilityCooldown;
    }

    @Override
    @Unique
    public void walkers$setAbilityCooldown(int abilityCooldown) {
        this.walkers$abilityCooldown = abilityCooldown;
    }

    @Override
    @Unique
    public class_1309 walkers$getCurrentShape() {
        return this.walkers$shape;
    }

    @Override
    @Unique
    public void walkers$setCurrentShape(class_1309 shape) {
        this.walkers$shape = shape;
    }

    @Override
    @Unique
    public boolean walkers$updateShapes(@Nullable class_1309 shape) {
        float currentHealthPercent;
        class_1657 player = (class_1657)this;
        class_1324 healthAttribute = player.method_5996(class_5134.field_23716);
        class_1324 attackAttribute = player.method_5996(class_5134.field_23721);
        EventResult result = ((ShapeEvents.ShapeSwapCallback)ShapeEvents.SWAP_SHAPE.invoker()).swap((class_3222)player, shape);
        if (result.isFalse()) {
            return false;
        }
        this.walkers$shape = shape;
        ((DimensionsRefresher)player).shape_refreshDimensions();
        if (shape != null) {
            if (Walkers.CONFIG.scalingHealth && healthAttribute != null) {
                currentHealthPercent = player.method_6032() / player.method_6063();
                healthAttribute.method_6192((double)Math.min((float)Walkers.CONFIG.maxHealth, shape.method_6063()));
                if (Walkers.CONFIG.percentScalingHealth) {
                    player.method_6033(Math.min(currentHealthPercent * player.method_6063(), player.method_6063()));
                } else {
                    player.method_6033(Math.min(player.method_6032(), player.method_6063()));
                }
            }
            if (Walkers.CONFIG.scalingAttackDamage.booleanValue() && attackAttribute != null) {
                double shapeAttackDamage = 1.0;
                try {
                    shapeAttackDamage = Math.max(shape.method_5996(class_5134.field_23721).method_6201(), shapeAttackDamage);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                attackAttribute.method_6192(Math.min(Walkers.CONFIG.maxAttackDamage, shapeAttackDamage));
            }
        }
        if (shape == null) {
            currentHealthPercent = player.method_6032() / player.method_6063();
            if (Walkers.CONFIG.scalingHealth && healthAttribute != null) {
                healthAttribute.method_6192(20.0);
            }
            if (Walkers.CONFIG.scalingAttackDamage.booleanValue() && attackAttribute != null) {
                attackAttribute.method_6192(1.0);
            }
            if (Walkers.CONFIG.percentScalingHealth) {
                player.method_6033(Math.min(currentHealthPercent * player.method_6063(), player.method_6063()));
            } else {
                player.method_6033(Math.min(player.method_6032(), player.method_6063()));
            }
        }
        class_3222 serverPlayer = (class_3222)player;
        if (Walkers.hasFlyingPermissions((class_3222)player)) {
            FlightHelper.grantFlightTo(serverPlayer);
            player.method_31549().method_7248(Walkers.CONFIG.flySpeed);
            player.method_7355();
        } else if (!player.method_7337()) {
            FlightHelper.revokeFlight(serverPlayer);
            player.method_31549().method_7248(0.05f);
            player.method_7355();
        }
        if (player.method_5854() instanceof class_1584 && (shape == null || !shape.method_5864().method_20210(WalkersEntityTags.RAVAGER_RIDING))) {
            player.method_5848();
        }
        if (!(shape instanceof class_1496)) {
            for (class_1297 passenger : player.method_5685()) {
                passenger.method_5848();
            }
        }
        if (!player.method_37908().field_9236) {
            PlayerShape.sync((class_3222)player);
            Int2ObjectMap<Object> trackers = ((ThreadedAnvilChunkStorageAccessor)((class_3218)player.method_37908()).method_14178().field_17254).getEntityMap();
            Object tracking = trackers.get(player.method_5628());
            ((EntityTrackerAccessor)tracking).getSeenBy().forEach(listener -> PlayerShape.sync((class_3222)player, listener.method_32311()));
        }
        return true;
    }

    @Override
    @Unique
    public Optional<UUID> walkers$getVehiclePlayerUUID() {
        return this.walkers$vehiclePlayerUUID;
    }

    @Override
    @Unique
    public void walkers$setVehiclePlayerUUID(UUID riddenPlayerUUID) {
        this.walkers$vehiclePlayerUUID = Optional.ofNullable(riddenPlayerUUID);
    }
}

