/*
 * Decompiled with CFR 0.152.
 */
package tocraft.walkers.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import dev.architectury.event.events.common.CommandRegistrationEvent;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2179;
import net.minecraft.class_2186;
import net.minecraft.class_2321;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_7157;
import net.minecraft.class_7733;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;
import tocraft.walkers.Walkers;
import tocraft.walkers.api.PlayerShape;
import tocraft.walkers.api.PlayerShapeChanger;
import tocraft.walkers.api.variant.ShapeType;
import tocraft.walkers.command.BlacklistCommands;
import tocraft.walkers.impl.PlayerDataProvider;

public class WalkersCommand {
    public static void register() {
        CommandRegistrationEvent.EVENT.register((dispatcher, ctx, b) -> {
            LiteralCommandNode rootNode = ((LiteralArgumentBuilder)class_2170.method_9247((String)"walkers").requires(source -> source.method_9259(2))).build();
            LiteralCommandNode remove2ndShape = ((LiteralArgumentBuilder)class_2170.method_9247((String)"remove2ndShape").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9308()).executes(context -> {
                WalkersCommand.remove2ndShape((class_2168)context.getSource(), class_2186.method_9315((CommandContext)context, (String)"player"));
                return 1;
            }))).build();
            LiteralCommandNode change2ndShape = ((LiteralArgumentBuilder)class_2170.method_9247((String)"change2ndShape").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9308()).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"shape", (ArgumentType)class_7733.method_45603((class_7157)ctx, (class_5321)class_7924.field_41266)).suggests(class_2321.field_10935).executes(context -> {
                WalkersCommand.change2ndShape((class_2168)context.getSource(), class_2186.method_9315((CommandContext)context, (String)"player"), class_1299.method_5890((class_1299)((class_1299)class_7733.method_45610((CommandContext)context, (String)"shape").comp_349())), null);
                return 1;
            })).then(class_2170.method_9244((String)"nbt", (ArgumentType)class_2179.method_9284()).executes(context -> {
                class_2487 nbt = class_2179.method_9285((CommandContext)context, (String)"nbt");
                WalkersCommand.change2ndShape((class_2168)context.getSource(), class_2186.method_9315((CommandContext)context, (String)"player"), class_1299.method_5890((class_1299)((class_1299)class_7733.method_45610((CommandContext)context, (String)"shape").comp_349())), nbt);
                return 1;
            }))))).build();
            LiteralCommandNode switchShape = ((LiteralArgumentBuilder)class_2170.method_9247((String)"switchShape").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9308()).then(class_2170.method_9247((String)"normal").executes(context -> {
                WalkersCommand.switchShapeToNormal((class_2168)context.getSource(), class_2186.method_9315((CommandContext)context, (String)"player"));
                return 1;
            }))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"shape", (ArgumentType)class_7733.method_45603((class_7157)ctx, (class_5321)class_7924.field_41266)).suggests(class_2321.field_10935).executes(context -> {
                WalkersCommand.switchShape((class_2168)context.getSource(), class_2186.method_9315((CommandContext)context, (String)"player"), class_1299.method_5890((class_1299)((class_1299)class_7733.method_45610((CommandContext)context, (String)"shape").comp_349())), null);
                return 1;
            })).then(class_2170.method_9244((String)"nbt", (ArgumentType)class_2179.method_9284()).executes(context -> {
                class_2487 nbt = class_2179.method_9285((CommandContext)context, (String)"nbt");
                WalkersCommand.switchShape((class_2168)context.getSource(), class_2186.method_9315((CommandContext)context, (String)"player"), class_1299.method_5890((class_1299)((class_1299)class_7733.method_45610((CommandContext)context, (String)"shape").comp_349())), nbt);
                return 1;
            }))))).build();
            LiteralCommandNode show2ndShape = ((LiteralArgumentBuilder)class_2170.method_9247((String)"show2ndShape").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(context -> WalkersCommand.show2ndShape((class_2168)context.getSource(), class_2186.method_9315((CommandContext)context, (String)"player"))))).build();
            rootNode.addChild((CommandNode)remove2ndShape);
            rootNode.addChild((CommandNode)change2ndShape);
            rootNode.addChild((CommandNode)switchShape);
            rootNode.addChild((CommandNode)show2ndShape);
            rootNode.addChild(BlacklistCommands.getRootNode());
            dispatcher.getRoot().addChild((CommandNode)rootNode);
        });
    }

    private static int show2ndShape(class_2168 source, class_3222 player) {
        if (((PlayerDataProvider)player).walkers$get2ndShape() != null) {
            if (Walkers.CONFIG.logCommands) {
                ShapeType<?> type = ((PlayerDataProvider)player).walkers$get2ndShape();
                Object[] objectArray = new Object[2];
                objectArray[0] = player.method_5476();
                objectArray[1] = ShapeType.createTooltipText(type.create(player.method_37908()));
                source.method_45068((class_2561)class_2561.method_43469((String)"walkers.show2ndShapeNot_positive", (Object[])objectArray));
            }
            return 1;
        }
        if (Walkers.CONFIG.logCommands) {
            source.method_45068((class_2561)class_2561.method_43469((String)"walkers.show2ndShapeNot_failed", (Object[])new Object[]{player.method_5476()}));
        }
        return 0;
    }

    private static void remove2ndShape(class_2168 source, class_3222 player) {
        boolean result = PlayerShapeChanger.change2ndShape(player, null);
        if (result && Walkers.CONFIG.logCommands) {
            player.method_7353((class_2561)class_2561.method_43471((String)"walkers.remove_entity"), true);
            source.method_45068((class_2561)class_2561.method_43469((String)"walkers.deletion_success", (Object[])new Object[]{player.method_5476()}));
        }
    }

    private static void change2ndShape(class_2168 source, class_3222 player, class_2960 id, @Nullable class_2487 nbt) {
        ShapeType<class_1299> type = ShapeType.from((class_1299)class_7923.field_41177.method_10223(id));
        class_5250 name = class_2561.method_43471((String)type.getEntityType().method_5882());
        if (nbt != null) {
            class_2487 copy = nbt.method_10553();
            copy.method_10582("id", id.toString());
            class_3218 serverWorld = source.method_9225();
            class_1297 loaded = class_1299.method_17842((class_2487)copy, (class_1937)serverWorld, it -> it);
            if (loaded instanceof class_1309) {
                class_1309 living = (class_1309)loaded;
                type = ShapeType.from(living);
                Object object = type != null ? ShapeType.createTooltipText(living) : (name = class_2561.method_30163((String)""));
            }
        }
        if (((PlayerDataProvider)player).walkers$get2ndShape() != type) {
            boolean result = PlayerShapeChanger.change2ndShape(player, type);
            if (result && Walkers.CONFIG.logCommands) {
                player.method_43496((class_2561)class_2561.method_43469((String)"walkers.unlock_entity", (Object[])new Object[]{name}));
                source.method_45068((class_2561)class_2561.method_43469((String)"walkers.grant_success", (Object[])new Object[]{name, player.method_5476()}));
            }
        } else if (Walkers.CONFIG.logCommands) {
            source.method_45068((class_2561)class_2561.method_43469((String)"walkers.already_has", (Object[])new Object[]{player.method_5476(), name}));
        }
    }

    private static void switchShape(class_2168 source, class_3222 player, class_2960 shape, @Nullable class_2487 nbt) {
        boolean result;
        class_1309 living;
        ShapeType<class_1309> defaultType;
        class_1297 created;
        if (nbt != null) {
            class_2487 copy = nbt.method_10553();
            copy.method_10582("id", shape.toString());
            class_3218 serverWorld = source.method_9225();
            created = class_1299.method_17842((class_2487)copy, (class_1937)serverWorld, it -> it);
        } else {
            class_1299 entity = (class_1299)class_7923.field_41177.method_10223(shape);
            created = entity.method_5883(player.method_37908());
        }
        if (created instanceof class_1309 && (defaultType = ShapeType.from(living = (class_1309)created)) != null && (result = PlayerShape.updateShapes(player, (class_1309)created)) && Walkers.CONFIG.logCommands) {
            source.method_45068((class_2561)class_2561.method_43469((String)"walkers.switchShape_success", (Object[])new Object[]{player.method_5476(), class_2561.method_43471((String)created.method_5864().method_5882())}));
        }
    }

    private static void switchShapeToNormal(class_2168 source, class_3222 player) {
        boolean result = PlayerShape.updateShapes(player, null);
        if (result && Walkers.CONFIG.logCommands) {
            source.method_45068((class_2561)class_2561.method_43469((String)"walkers.switchShape_human_success", (Object[])new Object[]{player.method_5476()}));
        }
    }
}

