/*
 * Decompiled with CFR 0.152.
 */
package tocraft.walkers.api.data.variants;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.architectury.platform.Platform;
import java.lang.reflect.InvocationTargetException;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1299;
import net.minecraft.class_156;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_7923;
import tocraft.walkers.Walkers;
import tocraft.walkers.api.data.variants.NBTTypeProvider;
import tocraft.walkers.api.variant.TypeProvider;
import tocraft.walkers.api.variant.TypeProviderRegistry;

public class TypeProviderDataManager
extends class_4309 {
    public static final Gson GSON = new GsonBuilder().registerTypeAdapter(class_2960.class, (Object)new class_2960.class_2961()).create();

    public TypeProviderDataManager() {
        super(GSON, "walkers/variants");
    }

    protected void apply(Map<class_2960, JsonElement> map, class_3300 resourceManager, class_3695 profiler) {
        for (Map.Entry<class_2960, JsonElement> mapEntry : map.entrySet()) {
            Map.Entry<class_1299<?>, TypeProvider<?>> convertedEntry = TypeProviderDataManager.typeProviderFromJson(mapEntry.getKey(), mapEntry.getValue().getAsJsonObject());
            if (convertedEntry.getKey() == null || convertedEntry.getValue() == null) continue;
            TypeProviderRegistry.register(convertedEntry.getKey(), convertedEntry.getValue());
            Walkers.LOGGER.info("{}: {} registered for {}", new Object[]{((Object)((Object)this)).getClass().getSimpleName(), convertedEntry.getKey(), convertedEntry.getValue()});
        }
    }

    protected static Map.Entry<class_1299<?>, TypeProvider<?>> typeProviderFromJson(class_2960 id, JsonObject json) {
        Codec codec = RecordCodecBuilder.create(instance -> instance.group((App)class_2960.field_25139.fieldOf("entity_type").forGetter(o -> class_7923.field_41177.method_10221((Object)((class_1299)o.getKey()))), (App)Codec.STRING.optionalFieldOf("required_mod", (Object)"").forGetter(o -> ""), (App)class_2960.field_25139.optionalFieldOf("parent").forGetter(o -> Optional.of(class_7923.field_41177.method_10221((Object)((class_1299)o.getKey())))), (App)Codec.STRING.optionalFieldOf("type_provider_class").forGetter(o -> Optional.of(((TypeProvider)o.getValue()).getClass().getName())), (App)NBTTypeProvider.CODEC.optionalFieldOf("type_provider").forGetter(o -> {
            Object patt2995$temp = o.getValue();
            if (patt2995$temp instanceof NBTTypeProvider) {
                NBTTypeProvider nbtTypeProvider = (NBTTypeProvider)patt2995$temp;
                return Optional.of(nbtTypeProvider);
            }
            return Optional.empty();
        })).apply((Applicative)instance, instance.stable((entityType, requiredMod, parent, typeProviderClassOptional, typeProviderOptional) -> {
            if ((requiredMod.isBlank() || Platform.isModLoaded((String)requiredMod)) && class_7923.field_41177.method_10250(entityType)) {
                TypeProvider typeProvider;
                if (parent.isPresent()) {
                    typeProvider = TypeProviderRegistry.getProvider((class_1299)class_7923.field_41177.method_10223((class_2960)parent.get()));
                } else if (typeProviderClassOptional.isPresent()) {
                    try {
                        typeProvider = Class.forName((String)typeProviderClassOptional.get()).asSubclass(TypeProvider.class).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                    catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                        Walkers.LOGGER.error("{}: No valid type provider class registered for {}", (Object)TypeProviderDataManager.class.getSimpleName(), (Object)id);
                        return new AbstractMap.SimpleEntry<class_1299, Object>((class_1299)class_7923.field_41177.method_10223(entityType), null);
                    }
                } else if (typeProviderOptional.isPresent()) {
                    typeProvider = (TypeProvider)typeProviderOptional.get();
                } else {
                    Walkers.LOGGER.error("{}: No valid type provider registered for {}", (Object)TypeProviderDataManager.class.getSimpleName(), (Object)id);
                    return new AbstractMap.SimpleEntry<class_1299, Object>((class_1299)class_7923.field_41177.method_10223(entityType), null);
                }
                return new AbstractMap.SimpleEntry<class_1299, TypeProvider>((class_1299)class_7923.field_41177.method_10223(entityType), typeProvider);
            }
            if (requiredMod.isBlank() || Platform.isModLoaded((String)requiredMod)) {
                Walkers.LOGGER.info("{}: EntityType not found for {}", (Object)TypeProviderDataManager.class.getSimpleName(), (Object)id);
            }
            return new AbstractMap.SimpleEntry<Object, Object>(null, null);
        })));
        return (Map.Entry)class_156.method_47526((DataResult)codec.parse((DynamicOps)JsonOps.INSTANCE, (Object)json), JsonParseException::new);
    }
}

