package tocraft.walkers.traits.impl;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1058;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1309;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import org.jetbrains.annotations.Nullable;
import tocraft.craftedcore.patched.CRegistries;
import tocraft.craftedcore.patched.Identifier;
import tocraft.walkers.Walkers;
import tocraft.walkers.traits.ShapeTrait;

import java.util.Objects;
import java.util.Optional;

public class MobEffectTrait<E extends class_1309> extends ShapeTrait<E> {
    public static final class_2960 ID = Walkers.id("mob_effect");
    //#if MC>=1205
    public static final MapCodec<class_1293> MOB_EFFECT_INSTANCE_CODEC = RecordCodecBuilder.mapCodec((instance) -> instance.group(
            class_2960.field_25139.fieldOf("id").forGetter(o -> ((class_2378<class_1291>) CRegistries.getRegistry(Identifier.parse("mob_effect"))).method_10221(o.method_5579().value())),
            Codec.INT.fieldOf("duration").forGetter(class_1293::method_5584),
            Codec.INT.fieldOf("amplifier").forGetter(class_1293::method_5578),
            Codec.BOOL.optionalFieldOf("ambient", false).forGetter(class_1293::method_5591),
            Codec.BOOL.optionalFieldOf("show_particles", true).forGetter(class_1293::method_5581),
            Codec.BOOL.optionalFieldOf("show_icon").forGetter(o -> Optional.of(o.method_5592()))
    ).apply(instance, instance.stable((id, duration, amplifier, ambient, show_particles, show_icon) -> new class_1293(((class_2378<class_1291>) CRegistries.getRegistry(Identifier.parse("mob_effect"))).method_40265(id).orElseThrow(), duration, amplifier, ambient, show_particles, show_icon.orElse(show_particles)))));
    //#else
    //$$ public static final Codec<MobEffectInstance> MOB_EFFECT_INSTANCE_CODEC = RecordCodecBuilder.create((instance) -> instance.group(
    //$$         ResourceLocation.CODEC.fieldOf("id").forGetter(o -> ((Registry<MobEffect>) CRegistries.getRegistry(Identifier.parse("mob_effect"))).getKey(o.getEffect())),
    //$$         Codec.INT.fieldOf("duration").forGetter(MobEffectInstance::getDuration),
    //$$         Codec.INT.fieldOf("amplifier").forGetter(MobEffectInstance::getAmplifier),
    //$$         Codec.BOOL.optionalFieldOf("ambient", false).forGetter(MobEffectInstance::isAmbient),
    //$$         Codec.BOOL.optionalFieldOf("show_particles", true).forGetter(MobEffectInstance::isVisible),
    //$$         Codec.BOOL.optionalFieldOf("show_icon").forGetter(o -> Optional.of(o.showIcon()))
    //$$ ).apply(instance, instance.stable((id, duration, amplifier, ambient, show_particles, show_icon) -> new MobEffectInstance(Objects.requireNonNull(((Registry<MobEffect>) CRegistries.getRegistry(Identifier.parse("mob_effect"))).get(id)), duration, amplifier, ambient, show_particles, show_icon.orElse(show_particles)))));
    //#endif
    public static final MapCodec<MobEffectTrait<?>> CODEC = RecordCodecBuilder.mapCodec((instance) -> instance.group(
            MOB_EFFECT_INSTANCE_CODEC.fieldOf("mob_effect").forGetter(o -> o.mobEffectInstance),
            Codec.BOOL.optionalFieldOf("show_in_inventory", true).forGetter(o -> o.showInInventory),
            Codec.BOOL.optionalFieldOf("apply_to_self", true).forGetter(o -> o.applyToSelf),
            Codec.INT.optionalFieldOf("apply_to_nearby", -1).forGetter(o -> o.applyToNearby),
            Codec.INT.optionalFieldOf("max_distance_for_entities", -1).forGetter(o -> o.maxDistanceForEntities),
            Codec.INT.optionalFieldOf("amount_of_entities_to_apply_to", -1).forGetter(o -> o.amountOfEntitiesToApplyTo)
    ).apply(instance, instance.stable(MobEffectTrait::new)));

    public final class_1293 mobEffectInstance;
    public final boolean showInInventory;
    public final boolean applyToSelf;
    public final int applyToNearby;
    public final int maxDistanceForEntities;
    public final int amountOfEntitiesToApplyTo;

    public MobEffectTrait(class_1293 mobEffectInstance) {
        this(mobEffectInstance, false);
    }

    public MobEffectTrait(class_1293 mobEffectInstance, boolean showInInventory) {
        this(mobEffectInstance, showInInventory, true, -1, -1, -1);
    }

    /**
     * @param mobEffectInstance         the effect to apply
     * @param showInInventory           should the effect be displayed to the player? Only for self
     * @param applyToSelf               should the player get it?
     * @param applyToNearby             should nearby entities get it? negative - no, 0 - player only, 1 - mobs only, 2 - players and mobs
     * @param maxDistanceForEntities    only used when applyToNearby is true
     * @param amountOfEntitiesToApplyTo only used when applyToNearby is true
     */
    public MobEffectTrait(class_1293 mobEffectInstance, boolean showInInventory, boolean applyToSelf, int applyToNearby, int maxDistanceForEntities, int amountOfEntitiesToApplyTo) {
        this.showInInventory = showInInventory;
        this.mobEffectInstance = mobEffectInstance;
        this.applyToSelf = applyToSelf;
        this.applyToNearby = applyToNearby;
        this.maxDistanceForEntities = maxDistanceForEntities;
        this.amountOfEntitiesToApplyTo = amountOfEntitiesToApplyTo;
    }

    @Override
    public class_2960 getId() {
        return ID;
    }

    @Override
    public MapCodec<? extends ShapeTrait<?>> codec() {
        return CODEC;
    }

    @Override
    @Environment(EnvType.CLIENT)
    public boolean iconMightDiffer() {
        return true;
    }

    @Override
    @Environment(EnvType.CLIENT)
    public @Nullable class_1058 getIcon() {
        return class_310.method_1551().method_18505().method_18663(mobEffectInstance.method_5579());
    }
}
