package tocraft.walkers.traits;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1299;
import net.minecraft.class_1307;
import net.minecraft.class_1309;
import net.minecraft.class_1311;
import net.minecraft.class_1420;
import net.minecraft.class_1428;
import net.minecraft.class_1433;
import net.minecraft.class_1439;
import net.minecraft.class_1451;
import net.minecraft.class_1453;
import net.minecraft.class_1456;
import net.minecraft.class_1463;
import net.minecraft.class_1472;
import net.minecraft.class_1473;
import net.minecraft.class_1481;
import net.minecraft.class_1493;
import net.minecraft.class_1496;
import net.minecraft.class_1510;
import net.minecraft.class_1528;
import net.minecraft.class_1545;
import net.minecraft.class_1547;
import net.minecraft.class_1548;
import net.minecraft.class_1564;
import net.minecraft.class_1569;
import net.minecraft.class_1584;
import net.minecraft.class_1593;
import net.minecraft.class_1613;
import net.minecraft.class_1627;
import net.minecraft.class_1628;
import net.minecraft.class_1634;
import net.minecraft.class_1639;
import net.minecraft.class_1642;
import net.minecraft.class_1646;
import net.minecraft.class_2246;
import net.minecraft.class_2960;
import net.minecraft.class_3483;
import net.minecraft.class_3486;
import net.minecraft.class_3701;
import net.minecraft.class_3763;
import net.minecraft.class_4019;
import net.minecraft.class_4466;
import net.minecraft.class_4985;
import net.minecraft.class_6862;
import net.minecraft.class_7298;
import net.minecraft.world.entity.animal.*;
import net.minecraft.world.entity.monster.*;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import tocraft.walkers.Walkers;
import tocraft.walkers.ability.ShapeAbility;
import tocraft.walkers.integrations.Integrations;
import tocraft.walkers.traits.impl.*;

import java.util.*;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;

@SuppressWarnings("unused")
public class TraitRegistry {
    private static final Map<Predicate<class_1309>, List<ShapeTrait<?>>> traitsByPredicates = new ConcurrentHashMap<>();
    private static final Map<class_1299<? extends class_1309>, List<ShapeTrait<?>>> traitsByEntityTypes = new ConcurrentHashMap<>();
    private static final Map<class_6862<class_1299<?>>, List<ShapeTrait<?>>> traitsByEntityTags = new ConcurrentHashMap<>();
    private static final Map<Class<? extends class_1309>, List<ShapeTrait<?>>> traitsByEntityClasses = new ConcurrentHashMap<>();
    private static final Map<class_2960, MapCodec<? extends ShapeTrait<?>>> traitCodecById = new HashMap<>();
    private static final Map<MapCodec<? extends ShapeTrait<?>>, class_2960> traitIdByCodec = new IdentityHashMap<>();

    @ApiStatus.Internal
    public static void initialize() {
        // register trait codecs
        registerCodec(MobEffectTrait.ID, MobEffectTrait.CODEC);
        registerCodec(BurnInDaylightTrait.ID, BurnInDaylightTrait.CODEC);
        registerCodec(FlyingTrait.ID, FlyingTrait.CODEC);
        registerCodec(PreyTrait.ID, PreyTrait.CODEC);
        registerCodec(TemperatureTrait.ID, TemperatureTrait.CODEC);
        registerCodec(RiderTrait.ID, RiderTrait.CODEC);
        registerCodec(StandOnFluidTrait.ID, StandOnFluidTrait.CODEC);
        registerCodec(NoPhysicsTrait.ID, NoPhysicsTrait.CODEC);
        registerCodec(CantSwimTrait.ID, CantSwimTrait.CODEC);
        registerCodec(UndrownableTrait.ID, UndrownableTrait.CODEC);
        registerCodec(SlowFallingTrait.ID, SlowFallingTrait.CODEC);
        registerCodec(FearedTrait.ID, FearedTrait.CODEC);
        registerCodec(ClimbBlocksTrait.ID, ClimbBlocksTrait.CODEC);
        registerCodec(ReinforcementsTrait.ID, ReinforcementsTrait.CODEC);
        registerCodec(InstantDieOnDamageMsgTrait.ID, InstantDieOnDamageMsgTrait.CODEC);
        registerCodec(AquaticTrait.ID, AquaticTrait.CODEC);
        registerCodec(WalkOnPowderSnow.ID, WalkOnPowderSnow.CODEC);
        registerCodec(HumanoidTrait.ID, HumanoidTrait.CODEC);
        registerCodec(AttackForHealthTrait.ID, AttackForHealthTrait.CODEC);
        registerCodec(NocturnalTrait.ID, NocturnalTrait.CODEC);
        registerCodec(CantInteractTrait.ID, CantInteractTrait.CODEC);
        registerCodec(ImmunityTrait.ID, ImmunityTrait.CODEC);
        registerCodec(CantFreezeTrait.ID, CantFreezeTrait.CODEC);
    }

    @SuppressWarnings("unchecked")
    @ApiStatus.Internal
    public static void registerDefault() {
        // register traits
        // mob effects
        registerByClass(class_1420.class, new MobEffectTrait<>(new class_1293(class_1294.field_5925, 100000, 0, false, false)));
        // burn in daylight
        registerByClass(class_1642.class, new BurnInDaylightTrait<>());
        registerByClass(class_1613.class, new BurnInDaylightTrait<>());
        registerByClass(class_1627.class, new BurnInDaylightTrait<>());
        registerByClass(class_1593.class, new BurnInDaylightTrait<>());
        // flying
        //#if MC>1182
        registerByClass(class_7298.class, new FlyingTrait<>());
        registerByClass(class_7298.class, new MobEffectTrait<>(new class_1293(class_1294.field_5924, 40, 2, false, false)));
        registerByClass(class_7298.class, new AttackForHealthTrait<>());
        //#endif
        registerByClass(class_1420.class, new FlyingTrait<>());
        registerByClass(class_4466.class, new FlyingTrait<>());
        registerByClass(class_1545.class, new FlyingTrait<>());
        registerByClass(class_1510.class, new FlyingTrait<>());
        registerByClass(class_1307.class, new FlyingTrait<>());
        registerByClass(class_1453.class, new FlyingTrait<>());
        registerByClass(class_1634.class, new FlyingTrait<>());
        registerByClass(class_1528.class, new FlyingTrait<>());
        // wolf prey
        registerByClass(class_1420.class, (PreyTrait<class_1420>) PreyTrait.ofHunterClass(class_1493.class));
        registerByClass(class_4019.class, (PreyTrait<class_4019>) PreyTrait.ofHunterClass(class_1493.class));
        registerByClass(class_1472.class, (PreyTrait<class_1472>) PreyTrait.ofHunterClass(class_1493.class));
        registerByClass(class_1613.class, (PreyTrait<class_1613>) PreyTrait.ofHunterClass(class_1493.class));
        registerByClass(class_1453.class, (PreyTrait<class_1453>) PreyTrait.ofHunterClass(class_1493.class));
        registerByClass(class_1463.class, (PreyTrait<class_1463>) PreyTrait.ofHunterClass(class_1493.class));
        // fox prey
        registerByClass(class_1428.class, (PreyTrait<class_1428>) PreyTrait.ofHunterClass(class_4019.class));
        registerByClass(class_1463.class, (PreyTrait<class_1463>) PreyTrait.ofHunterClass(class_4019.class));
        registerByPredicate(entity -> entity instanceof class_1481 && entity.method_6109(), PreyTrait.ofHunterClass(class_4019.class));
        // ocelot prey
        registerByClass(class_1428.class, (PreyTrait<class_1428>) PreyTrait.ofHunterClass(class_3701.class));
        // hostile attacked by iron golem
        registerByPredicate(entity -> entity instanceof class_1569 && !(entity instanceof class_1548), new PreyTrait<>(List.of(), List.of(), List.of(class_1439.class), List.of(), 3, 5));
        // hurt by high temperature
        registerByClass(class_1473.class, new TemperatureTrait<>());
        // ravager riding
        registerByTag(class_3483.field_19168, (RiderTrait<class_1564>) RiderTrait.ofRideableClass(class_1584.class));
        registerByClass(class_1613.class, (RiderTrait<class_1613>) RiderTrait.ofRideableClass(class_1628.class));
        // Zombie Horse and Skeleton Horse riding
        registerByPredicate(entity -> entity instanceof class_1569, new RiderTrait<>(List.of(rideable -> rideable instanceof class_1496 && rideable instanceof class_1569)));
        // lava walking
        registerByClass(class_4985.class, new StandOnFluidTrait<>(class_3486.field_15518));
        // fall through blocks
        registerByClass(class_1634.class, new NoPhysicsTrait<>());
        // can't swim
        registerByClass(class_1439.class, new CantSwimTrait<>());
        // undrownable
        registerByClass(class_1439.class, new UndrownableTrait<>());
        // feared
        registerByClass(class_1493.class, (FearedTrait<class_1493>) FearedTrait.ofFearfulClass(class_1547.class));
        registerByPredicate(entity -> entity instanceof class_3701 || entity instanceof class_1451, FearedTrait.ofFearfulClass(class_1548.class));
        registerByClass(class_3701.class, (FearedTrait<class_3701>) FearedTrait.ofFearfulClass(class_1428.class));
        // climb blocks
        registerByClass(class_1628.class, new ClimbBlocksTrait<>());
        registerByClass(class_1628.class, new ClimbBlocksTrait<>(List.of(class_2246.field_10343), new ArrayList<>()));
        // reinforcements
        registerByClass(class_1493.class, new ReinforcementsTrait<>());
        registerByClass(class_4466.class, new ReinforcementsTrait<>());
        registerByTag(class_3483.field_19168, new ReinforcementsTrait<>(32, new ArrayList<>(), List.of(class_3483.field_19168)));
        // instant die on lightning
        registerByClass(class_1481.class, new InstantDieOnDamageMsgTrait<>("lightningBolt"));
        // cats hunt rabbits
        registerByClass(class_1463.class, new PreyTrait<>(List.of(entity -> entity instanceof class_1451 cat && !cat.method_6181())));
        // aquatic
        registerByPredicate(entity -> entity.method_5864().method_5891().method_6133().contains("water") && entity.method_6094(), new AquaticTrait<>());
        registerByPredicate(entity -> entity.method_5864().method_5891().method_6133().contains("water") != entity.method_6094(), new AquaticTrait<>(true, true));
        // dolphin don't like sun
        registerByClass(class_1433.class, new AquaticTrait<>());
        // walk on powder snow
        registerByClass(class_1463.class, new WalkOnPowderSnow<>());
        // slow falling
        registerByClass(class_1428.class, new SlowFallingTrait<>());
        // support deprecated entity tags
        registerByTag(class_6862.method_40092(Walkers.getEntityTypeRegistry().method_30517(), Walkers.id("burns_in_daylight")), new BurnInDaylightTrait<>());
        registerByTag(class_6862.method_40092(Walkers.getEntityTypeRegistry().method_30517(), Walkers.id("flying")), new FlyingTrait<>(false));
        registerByTag(class_6862.method_40092(Walkers.getEntityTypeRegistry().method_30517(), Walkers.id("slow_falling")), new SlowFallingTrait<>());
        registerByTag(class_6862.method_40092(Walkers.getEntityTypeRegistry().method_30517(), Walkers.id("wolf_prey")), PreyTrait.ofHunterClass(class_1493.class));
        registerByTag(class_6862.method_40092(Walkers.getEntityTypeRegistry().method_30517(), Walkers.id("fox_prey")), PreyTrait.ofHunterClass(class_4019.class));
        registerByTag(class_6862.method_40092(Walkers.getEntityTypeRegistry().method_30517(), Walkers.id("hurt_by_high_temperature")), new TemperatureTrait<>());
        registerByTag(class_6862.method_40092(Walkers.getEntityTypeRegistry().method_30517(), Walkers.id("ravager_riding")), RiderTrait.ofRideableClass(class_1584.class));
        registerByTag(class_6862.method_40092(Walkers.getEntityTypeRegistry().method_30517(), Walkers.id("lava_walking")), new StandOnFluidTrait<>(class_3486.field_15518));
        registerByTag(class_6862.method_40092(Walkers.getEntityTypeRegistry().method_30517(), Walkers.id("fall_through_blocks")), new NoPhysicsTrait<>());
        registerByTag(class_6862.method_40092(Walkers.getEntityTypeRegistry().method_30517(), Walkers.id("cant_swim")), new CantSwimTrait<>());
        registerByTag(class_6862.method_40092(Walkers.getEntityTypeRegistry().method_30517(), Walkers.id("undrownable")), new UndrownableTrait<>());
        // Attack for Health
        registerByPredicate(entity -> entity.method_5864().method_5891().equals(class_1311.field_6302), new AttackForHealthTrait<>());
        // nocturnal
        registerByPredicate(entity -> entity.method_5864().method_5891().equals(class_1311.field_6302), new NocturnalTrait<>());
        // cant interact with...
        registerByClass(class_3763.class, new CantInteractTrait<>(List.of(class_1646.class)));
        // immunity
        //#if MC>=1205
        registerByClass(class_1528.class, new ImmunityTrait<>(class_1294.field_5920.value()));
        registerByClass(class_1639.class, new ImmunityTrait<>(class_1294.field_5920.value()));
        //#else
        //$$ registerByClass(WitherBoss.class, new ImmunityTrait<>(MobEffects.WITHER));
        //$$ registerByClass(WitherSkeleton.class, new ImmunityTrait<>(MobEffects.WITHER));
        //#endif
        // can't freeze
        registerByClass(class_1473.class, new CantFreezeTrait<>());
        registerByClass(class_1456.class, new CantFreezeTrait<>());
        registerByClass(class_1627.class, new CantFreezeTrait<>());

        // handle Integrations
        Integrations.registerTraits();
    }

    /**
     * @return a list of every available trait for the specified entity
     */
    @SuppressWarnings("unchecked")
    public static synchronized <L extends class_1309> List<ShapeTrait<L>> getAll(L shape) {
        List<ShapeTrait<L>> traits = new ArrayList<>();
        if (shape != null) {
            List<ShapeTrait<?>> list = traitsByEntityTypes.get(shape.method_5864());
            if (list != null) {
                traits.addAll(list.stream().map(trait -> (ShapeTrait<L>) trait).toList());
            }
            for (Class<? extends class_1309> aClass : traitsByEntityClasses.keySet()) {
                if (aClass.isInstance(shape))
                    traits.addAll(traitsByEntityClasses.get(aClass).stream().map(trait -> (ShapeTrait<L>) trait).toList());
            }
            for (Map.Entry<class_6862<class_1299<?>>, List<ShapeTrait<?>>> entry : traitsByEntityTags.entrySet()) {
                if (shape.method_5864().method_20210(entry.getKey())) {
                    traits.addAll(entry.getValue().stream().map(trait -> (ShapeTrait<L>) trait).toList());
                }
            }
            for (Map.Entry<Predicate<class_1309>, List<ShapeTrait<?>>> entry : traitsByPredicates.entrySet()) {
                if (entry.getKey().test(shape)) {
                    traits.addAll(entry.getValue().stream().map(trait -> (ShapeTrait<L>) trait).toList());
                }
            }
        }
        return traits;
    }

    /**
     * @return a list of every available trait for the specified entity
     */
    public static synchronized <L extends class_1309> List<ShapeTrait<L>> get(L shape, class_2960 traitId) {
        List<ShapeTrait<L>> traits = getAll(shape);
        List<ShapeTrait<L>> filteredTraits = new ArrayList<>();
        for (ShapeTrait<L> trait : traits) {
            if (trait.getId() == traitId) {
                filteredTraits.add(trait);
            }
        }
        return filteredTraits;
    }

    @ApiStatus.Experimental
    public static synchronized Map<ShapeTrait<?>, Predicate<class_1309>> getAllRegisteredById(class_2960 traitId) {
        Map<ShapeTrait<?>, Predicate<class_1309>> traits = new HashMap<>();
        for (Map.Entry<class_1299<? extends class_1309>, List<ShapeTrait<?>>> traitList : traitsByEntityTypes.entrySet()) {
            for (ShapeTrait<?> trait : traitList.getValue()) {
                if (trait.getId() == traitId) {
                    traits.put(trait, entity -> entity.method_5864().equals(traitList.getKey()));
                }
            }
        }
        for (Map.Entry<Class<? extends class_1309>, List<ShapeTrait<?>>> traitList : traitsByEntityClasses.entrySet()) {
            for (ShapeTrait<?> trait : traitList.getValue()) {
                if (trait.getId() == traitId) {
                    traits.put(trait, entity -> traitList.getKey().isInstance(entity));
                }
            }
        }
        for (Map.Entry<class_6862<class_1299<?>>, List<ShapeTrait<?>>> traitList : traitsByEntityTags.entrySet()) {
            for (ShapeTrait<?> trait : traitList.getValue()) {
                if (trait.getId() == traitId) {
                    traits.put(trait, entity -> entity.method_5864().method_20210(traitList.getKey()));
                }
            }
        }
        for (Map.Entry<Predicate<class_1309>, List<ShapeTrait<?>>> traitList : traitsByPredicates.entrySet()) {
            for (ShapeTrait<?> trait : traitList.getValue()) {
                if (trait.getId() == traitId) {
                    traits.put(trait, traitList.getKey());
                }
            }
        }
        return traits;
    }

    /**
     * must be called within {@link #registerDefault()} or {@link tocraft.walkers.integrations.AbstractIntegration#registerTraits() Integration.registerTraits()}
     */
    public static <A extends class_1309> void registerByType(class_1299<A> type, ShapeTrait<A> trait) {
        registerByType(type, List.of(trait));
    }

    /**
     * must be called within {@link #registerDefault()} or {@link tocraft.walkers.integrations.AbstractIntegration#registerTraits() Integration.registerTraits()}
     */
    public static <A extends class_1309> void registerByType(class_1299<A> type, List<ShapeTrait<A>> newtraits) {
        List<ShapeTrait<?>> traits = traitsByEntityTypes.containsKey(type) ? traitsByEntityTypes.get(type) : new ArrayList<>();
        for (ShapeTrait<A> trait : newtraits) {
            if (trait.canBeRegisteredMultipleTimes() || traits.stream().noneMatch(entry -> entry.getId().equals(trait.getId()))) {
                traits.add(trait);
            }
        }
        traitsByEntityTypes.put(type, traits);
    }

    /**
     * must be called within {@link #registerDefault()} or {@link tocraft.walkers.integrations.AbstractIntegration#registerTraits() Integration.registerTraits()}
     */
    public static <A extends class_1309> void registerByTag(class_6862<class_1299<?>> tag, ShapeTrait<A> trait) {
        registerByTag(tag, List.of(trait));
    }

    /**
     * must be called within {@link #registerDefault()} or {@link tocraft.walkers.integrations.AbstractIntegration#registerTraits() Integration.registerTraits()}
     */
    public static <A extends class_1309> void registerByTag(class_6862<class_1299<?>> tag, List<ShapeTrait<A>> newtraits) {
        List<ShapeTrait<?>> traits = traitsByEntityTags.containsKey(tag) ? traitsByEntityTags.get(tag) : new ArrayList<>();
        for (ShapeTrait<A> trait : newtraits) {
            if (trait.canBeRegisteredMultipleTimes() || traits.stream().noneMatch(entry -> entry.getId().equals(trait.getId()))) {
                traits.add(trait);
            }
        }
        traitsByEntityTags.put(tag, traits);
    }

    /**
     * must be called within {@link #registerDefault()} or {@link tocraft.walkers.integrations.AbstractIntegration#registerTraits() Integration.registerTraits()}
     */
    public static <A extends class_1309> void registerByClass(Class<A> entityClass, ShapeTrait<A> trait) {
        registerByClass(entityClass, List.of(trait));
    }

    /**
     * must be called within {@link #registerDefault()} or {@link tocraft.walkers.integrations.AbstractIntegration#registerTraits() Integration.registerTraits()}
     */
    public static <A extends class_1309> void registerByClass(Class<A> entityClass, List<ShapeTrait<A>> newtraits) {
        List<ShapeTrait<?>> traits = traitsByEntityClasses.containsKey(entityClass) ? traitsByEntityClasses.get(entityClass) : new ArrayList<>();
        for (ShapeTrait<A> trait : newtraits) {
            if (trait.canBeRegisteredMultipleTimes() || traits.stream().noneMatch(entry -> entry.getId().equals(trait.getId()))) {
                traits.add(trait);
            }
        }
        traitsByEntityClasses.put(entityClass, traits);
    }

    /**
     * Register a trait for a predicate
     * must be called within {@link #registerDefault()} or {@link tocraft.walkers.integrations.AbstractIntegration#registerTraits() Integration.registerTraits()}
     *
     * @param entityPredicate this should only be true, if the entity is the correct class for the ability!
     * @param trait           your {@link ShapeAbility}
     */
    public static void registerByPredicate(Predicate<class_1309> entityPredicate, ShapeTrait<?> trait) {
        registerByPredicate(entityPredicate, List.of(trait));
    }

    /**
     * Register a list of traits for a predicate
     * must be called within {@link #registerDefault()} or {@link tocraft.walkers.integrations.AbstractIntegration#registerTraits() Integration.registerTraits()}
     */
    public static void registerByPredicate(Predicate<class_1309> entityPredicate, List<ShapeTrait<?>> newTraits) {
        List<ShapeTrait<?>> traits = traitsByPredicates.containsKey(entityPredicate) ? traitsByPredicates.get(entityPredicate) : new ArrayList<>();
        for (ShapeTrait<?> trait : newTraits) {
            if (trait.canBeRegisteredMultipleTimes() || traits.stream().noneMatch(entry -> entry.getId().equals(trait.getId()))) {
                traits.add(trait);
            }
        }
        traitsByPredicates.put(entityPredicate, traits);
    }

    public static void registerCodec(class_2960 traitId, MapCodec<? extends ShapeTrait<?>> traitCodec) {
        traitCodecById.put(traitId, traitCodec);
        traitIdByCodec.put(traitCodec, traitId);
    }

    @Nullable
    @ApiStatus.Internal
    public static MapCodec<? extends ShapeTrait<?>> getTraitCodec(class_2960 traitId) {
        return traitCodecById.get(traitId);
    }

    @Nullable
    @ApiStatus.Internal
    public static class_2960 getTraitId(MapCodec<? extends ShapeTrait<?>> traitCodec) {
        return traitIdByCodec.get(traitCodec);
    }

    public static <L extends class_1309> boolean has(L shape, class_2960 traitId) {
        if (shape != null) {
            List<ShapeTrait<?>> list = traitsByEntityTypes.get(shape.method_5864());
            if (list != null && list.stream().anyMatch(trait -> trait.getId() == traitId)) {
                return true;
            }
            for (Map.Entry<Class<? extends class_1309>, List<ShapeTrait<?>>> entry : traitsByEntityClasses.entrySet()) {
                if (entry.getKey().isInstance(shape) && entry.getValue().stream().anyMatch(trait -> trait.getId() == traitId)) {
                    return true;
                }
            }
            for (Map.Entry<class_6862<class_1299<?>>, List<ShapeTrait<?>>> entry : traitsByEntityTags.entrySet()) {
                if (shape.method_5864().method_20210(entry.getKey()) && entry.getValue().stream().anyMatch(trait -> trait.getId() == traitId)) {
                    return true;
                }
            }
            for (Map.Entry<Predicate<class_1309>, List<ShapeTrait<?>>> entry : traitsByPredicates.entrySet()) {
                if (entry.getKey().test(shape) && entry.getValue().stream().anyMatch(trait -> trait.getId() == traitId)) {
                    return true;
                }
            }
        }
        return false;
    }

    @ApiStatus.Internal
    public static void clearAll() {
        traitsByEntityTypes.clear();
        traitsByEntityClasses.clear();
        traitsByEntityTags.clear();
        traitsByPredicates.clear();
    }

    @ApiStatus.Internal
    public static Codec<ShapeTrait<?>> getTraitCodec() {
        Codec<MapCodec<? extends ShapeTrait<?>>> codec = class_2960.field_25139.flatXmap(
                resourceLocation -> Optional.ofNullable(TraitRegistry.getTraitCodec(resourceLocation))
                        .map(DataResult::success)
                        .orElseGet(() -> Walkers.dataError("Unknown shape trait: " + resourceLocation)),
                traitCodec -> Optional.ofNullable(getTraitId(traitCodec))
                        .map(DataResult::success)
                        .orElseGet(() -> Walkers.dataError("Unknown shape trait codec: " + traitCodec))
        );
        //#if MC>=1205
        return codec.dispatchStable(ShapeTrait::codec, Function.identity());
        //#else
        //$$ return codec.dispatchStable(ShapeTrait::codec, MapCodec::codec);
        //#endif
    }
}
