package tocraft.walkers.mixin;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import tocraft.walkers.api.PlayerShape;

import java.util.Optional;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_4760;
import net.minecraft.class_4835;

@Mixin(class_4835.class)
public class HoglinBrainMixin {

    @Inject(
            method = "findNearestValidAttackTarget",
            at = @At("RETURN"),
            cancellable = true)
    private static void findNearestValidAttackTarget(class_4760 hoglin, CallbackInfoReturnable<Optional<? extends class_1309>> cir) {
        Optional<? extends class_1309> ret = cir.getReturnValue();
        if (ret.isPresent()) {
            class_1309 target = ret.get();

            // Check if Hoglin target is player
            if (target instanceof class_1657 player) {
                class_1309 shape = PlayerShape.getCurrentShape(player);

                // Ensure player shape is valid
                if (shape != null) {
                    if (shape instanceof class_4760) {
                        cir.setReturnValue(Optional.empty());
                    }
                }
            }
        }
    }
}
