package tocraft.walkers.integrations.impl;

import com.mojang.datafixers.util.Either;
import tocraft.walkers.api.data.variants.NBTEntry;
import tocraft.walkers.api.data.variants.NBTTypeProvider;
import tocraft.walkers.api.variant.TypeProvider;
import tocraft.walkers.api.variant.TypeProviderRegistry;
import tocraft.walkers.integrations.AbstractIntegration;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1299;
import net.minecraft.class_1493;

public class BackportedWolvesIntegration extends AbstractIntegration {
    public static final String MODID = "backported_wolves";
    private final Map<String, String> WOLF_VARIANT_NAME_MAP = new HashMap<>() {
        {
            put("0", "Plae %s");
            put("1", "Woods %s");
            put("2", "Ashen %s");
            put("3", "Black %s");
            put("4", "Chestnut %s");
            put("5", "Rusty %s");
            put("6", "Spotted %s");
            put("7", "Striped %s");
            put("8", "Snowy %s");
        }
    };
    private final NBTEntry<class_1493> WOLF_NBT_ENTRY = new NBTEntry<>("INTEGER", "Variant", new HashMap<>(), false);
    private final TypeProvider<class_1493> WOLF_VARIANT_PROVIDER = new NBTTypeProvider<>(0, 8, Either.left(List.of(WOLF_NBT_ENTRY)), WOLF_VARIANT_NAME_MAP);

    @Override
    public void registerTypeProvider() {
        TypeProviderRegistry.register(class_1299.field_6055, WOLF_VARIANT_PROVIDER);
    }
}
