package tocraft.walkers.impl.tick;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_239;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3966;
import org.jetbrains.annotations.Nullable;
import tocraft.craftedcore.event.client.ClientTickEvents;
import tocraft.craftedcore.patched.TComponent;
import tocraft.walkers.Walkers;
import tocraft.walkers.WalkersClient;
import tocraft.walkers.ability.AbilityRegistry;
import tocraft.walkers.api.PlayerShape;
import tocraft.walkers.api.blacklist.EntityBlacklist;
import tocraft.walkers.api.platform.ApiLevel;
import tocraft.walkers.api.variant.ShapeType;
import tocraft.walkers.impl.PlayerDataProvider;
import tocraft.walkers.network.ClientNetworking;
import tocraft.walkers.network.impl.SwapPackets;
import tocraft.walkers.network.impl.SwapVariantPackets;
import tocraft.walkers.network.impl.UnlockPackets;

@Environment(EnvType.CLIENT)
public class KeyPressHandler implements ClientTickEvents.Client {
    private float currentTimer = 0f;

    @Override
    public void tick(class_310 client) {
        if (client.field_1724 != null) {
            if (WalkersClient.ABILITY_KEY.method_1436()) handleAbilityKey(client);

            if (WalkersClient.TRANSFORM_KEY.method_1436()) {
                if (ApiLevel.getCurrentLevel().canMorph) {
                    SwapPackets.sendSwapRequest();
                } else {
                    client.field_1724.method_7353(TComponent.translatable("walkers.feature_not_available"), true);
                }
            }

            if (WalkersClient.VARIANTS_MENU_KEY.method_1436() && Walkers.CONFIG.unlockEveryVariant) {
                if (ApiLevel.getCurrentLevel().allowVariantsMenu) {
                    class_1309 shape = PlayerShape.getCurrentShape(client.field_1724);
                    if (shape != null) {
                        ShapeType<?> shapeType = ShapeType.from(shape);
                        if (WalkersClient.isRenderingVariantsMenu) {
                            SwapVariantPackets.sendSwapRequest(shapeType.getVariantData() + WalkersClient.variantOffset);
                        }
                        WalkersClient.variantOffset = 0;
                        WalkersClient.isRenderingVariantsMenu = !WalkersClient.isRenderingVariantsMenu;
                    }
                } else {
                    client.field_1724.method_7353(TComponent.translatable("walkers.feature_not_available"), true);
                }
            }

            // disable variants menu when in other menu
            if (WalkersClient.isRenderingVariantsMenu && (client.field_1690.field_1842 || !Walkers.CONFIG.unlockEveryVariant || client.field_1755 != null || PlayerShape.getCurrentShape(client.field_1724) == null))
                WalkersClient.isRenderingVariantsMenu = false;

            if (WalkersClient.UNLOCK_KEY.method_1434()) {
                if (ApiLevel.getCurrentLevel().canUnlock) {
                    handleUnlockKey(client);
                } else {
                    client.field_1724.method_7353(TComponent.translatable("walkers.feature_not_available"), true);
                }
            } else if (currentTimer != Walkers.CONFIG.unlockTimer) currentTimer = Walkers.CONFIG.unlockTimer;
        }
    }

    private void handleAbilityKey(class_310 client) {
        class_1309 shape = PlayerShape.getCurrentShape(client.field_1724);

        if (shape != null) {
            if (AbilityRegistry.has(shape)) {
                ClientNetworking.sendAbilityRequest();
            }
        }
    }

    //TODO: Merge this into something similar to the OnInteractEvent
    @SuppressWarnings("ConstantConditions")
    private void handleUnlockKey(class_310 client) {
        // check if player is blacklisted
        if (client.field_1724 != null && Walkers.isPlayerBlacklisted(client.field_1724.method_5667()) && Walkers.CONFIG.blacklistPreventsUnlocking) {
            client.field_1724.method_7353(TComponent.translatable("walkers.player_blacklisted"), true);
            return;
        }

        class_239 hit = client.field_1765;
        if (client.field_1724 != null && (((PlayerDataProvider) client.field_1724).walkers$get2ndShape() == null || Walkers.CONFIG.unlockOverridesCurrentShape) && hit instanceof class_3966) {
            class_1297 entityHit = ((class_3966) hit).method_17782();
            if (entityHit instanceof class_1309 living) {
                @Nullable ShapeType<?> type = ShapeType.from(living);

                if (type != null) {
                    // Ensures, the mob isn't on the blacklist
                    if (EntityBlacklist.isBlacklisted(type.getEntityType()))
                        client.field_1724.method_7353(TComponent.translatable("walkers.unlock_entity_blacklisted"), true);
                    else {
                        if (currentTimer <= 0) {
                            // unlock shape
                            UnlockPackets.sendUnlockRequest(type);
                            // send unlock message
                            class_2561 name = TComponent.translatable(type.getEntityType().method_5882());
                            client.field_1724.method_7353(TComponent.translatable("walkers.unlock_entity", name), true);
                            currentTimer = Walkers.CONFIG.unlockTimer;
                        } else {
                            client.field_1724.method_7353(TComponent.translatable("walkers.unlock_progress"), true);
                            currentTimer -= 1;
                        }
                    }
                }
            }
        } else currentTimer = Walkers.CONFIG.unlockTimer;
    }
}
