package tocraft.walkers.fabric.mixin;

import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_3486;
import net.minecraft.world.entity.*;
import org.objectweb.asm.Opcodes;
import org.spongepowered.asm.mixin.Mixin;
import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import org.spongepowered.asm.mixin.injection.At;
import tocraft.walkers.api.PlayerShape;
import tocraft.walkers.traits.ShapeTrait;
import tocraft.walkers.traits.TraitRegistry;
import tocraft.walkers.traits.impl.*;

@Mixin(class_1657.class)
public class PlayerMixin {
    //#if MC>1194
    @ModifyExpressionValue(method = "getDestroySpeed", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/entity/player/Player;onGround()Z"))
    //#else
    //$$ @ModifyExpressionValue(method = "getDestroySpeed", at = @At(value = "FIELD", target = "Lnet/minecraft/world/entity/player/Player;onGround:Z", opcode = Opcodes.GETFIELD))
    //#endif
    private boolean onModifyBreakingSpeedOnFlight(boolean original) {
        if (TraitRegistry.has(PlayerShape.getCurrentShape((class_1657) (Object) this), FlyingTrait.ID)) {
            return true;
        }
        else if (((class_1657) (Object) this).method_5777(class_3486.field_15517)) {
            for (ShapeTrait<class_1309> aquaticTrait : TraitRegistry.get(PlayerShape.getCurrentShape((class_1657) (Object) this), AquaticTrait.ID)) {
                if (((AquaticTrait<class_1309>) aquaticTrait).isAquatic) {
                    return true;
                }
            }
        }
        return original;
    }

    @ModifyExpressionValue(method = "getDestroySpeed", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/entity/player/Player;isEyeInFluid(Lnet/minecraft/tags/TagKey;)Z"))
    private boolean onModifyBreakingSpeedWhenSwimming(boolean original) {
        for (ShapeTrait<class_1309> aquaticTrait : TraitRegistry.get(PlayerShape.getCurrentShape((class_1657) (Object) this), AquaticTrait.ID)) {
            if (((AquaticTrait<class_1309>) aquaticTrait).isAquatic) {
                return false;
            }
        }
        return original;
    }
}
