package tocraft.walkers.api.variant;

import com.mojang.datafixers.util.Pair;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import tocraft.walkers.impl.variant.*;
import tocraft.walkers.integrations.Integrations;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1299;
import net.minecraft.class_1309;

@SuppressWarnings("unused")
public class TypeProviderRegistry {
    private static final Map<class_1299<? extends class_1309>, TypeProvider<? extends class_1309>> VARIANT_BY_TYPE = new LinkedHashMap<>();

    @ApiStatus.Internal
    public static void registerDefault() {
        register(class_1299.field_6046, new CreeperTypeProvider());
        register(class_1299.field_6115, new SheepTypeProvider());
        register(class_1299.field_28315, new AxolotlTypeProvider());
        register(class_1299.field_6104, new ParrotTypeProvider());
        register(class_1299.field_17943, new FoxTypeProvider());
        register(class_1299.field_16281, new CatTypeProvider());
        register(class_1299.field_6069, new SlimeTypeProvider());
        //#if MC>1182
        register(class_1299.field_37419, new FrogTypeProvider());
        //#endif
        register(class_1299.field_6139, new HorseTypeProvider());
        register(class_1299.field_6074, new LlamaTypeProvider<>());
        register(class_1299.field_17714, new LlamaTypeProvider<>());
        register(class_1299.field_6102, new MagmaCubeTypeProvider());
        register(class_1299.field_6143, new MushroomCowTypeProvider());
        register(class_1299.field_6146, new PandaTypeProvider());
        register(class_1299.field_6140, new RabbitTypeProvider());
        register(class_1299.field_6077, new VillagerTypeProvider());
        register(class_1299.field_6054, new ZombieVillagerTypeProvider());
        register(class_1299.field_6111, new TropicalFishTypeProvider());
        register(class_1299.field_6109, new ShulkerTypeProvider());
        //#if MC>=1205
        register(class_1299.field_6055, new WolfTypeProvider());
        //#endif

        // handle Integrations
        Integrations.registerTypeProvider();
    }

    /**
     * must be called within {@link #registerDefault()} or {@link tocraft.walkers.integrations.AbstractIntegration#registerTypeProvider Integration.registerTypeProvider()}}
     */
    public static <T extends class_1309> void register(class_1299<T> type, TypeProvider<T> provider) {
        VARIANT_BY_TYPE.put(type, provider);
    }

    public static <T extends class_1309> boolean hasProvider(class_1299<T> type) {
        return VARIANT_BY_TYPE.containsKey(type);
    }

    @SuppressWarnings("unchecked")
    @Nullable
    public static <T extends class_1309> TypeProvider<T> getProvider(class_1299<T> type) {
        return (TypeProvider<T>) VARIANT_BY_TYPE.get(type);
    }

    /**
     * @return a list of every entity type with their registered type provider
     */
    @ApiStatus.Internal
    public static List<Pair<class_1299<? extends class_1309>, TypeProvider<?>>> getAll() {
        List<Pair<class_1299<? extends class_1309>, TypeProvider<?>>> typeList = new ArrayList<>();
        VARIANT_BY_TYPE.forEach((entityType, typeProvider) -> typeList.add(new Pair<>(entityType, typeProvider)));
        return typeList;
    }

    @ApiStatus.Internal
    public static void clearAll() {
        VARIANT_BY_TYPE.clear();
    }
}
