package tocraft.walkers.api.events;

import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;
import tocraft.craftedcore.event.Event;
import tocraft.craftedcore.event.EventFactory;
import tocraft.walkers.ability.ShapeAbility;
import tocraft.walkers.api.variant.ShapeType;

public final class ShapeEvents {
    /**
     * Called when using the default unlocking mechanic
     */
    public static final Event<UnlockShapeCallback> UNLOCK_SHAPE = EventFactory.createWithInteractionResult();

    /**
     * Called when morphing
     */
    public static final Event<ShapeSwapCallback> SWAP_SHAPE = EventFactory.createWithInteractionResult();

    /**
     * Called when a {@link ShapeAbility ShapeAbility} is used
     */
    public static final Event<UseShapeAbilityCallback> USE_SHAPE_ABILITY = EventFactory.createWithInteractionResult();

    @FunctionalInterface
    public interface ShapeSwapCallback {
        class_1269 swap(class_3222 player, @Nullable class_1309 to);
    }

    @FunctionalInterface
    public interface UnlockShapeCallback {
        class_1269 unlock(class_3222 player, ShapeType<?> type);
    }

    @FunctionalInterface
    public interface UseShapeAbilityCallback {
        class_1269 use(class_1657 player, ShapeAbility<?> ability);
    }
}
