package tocraft.walkers.api.data.traits;

import com.google.gson.*;
import com.mojang.serialization.Codec;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import tocraft.craftedcore.data.SynchronizedJsonReloadListener;
import tocraft.craftedcore.platform.PlatformData;
import tocraft.walkers.Walkers;
import tocraft.walkers.traits.ShapeTrait;
import tocraft.walkers.traits.TraitRegistry;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_2960;
import net.minecraft.class_6862;

public class TraitDataManager extends SynchronizedJsonReloadListener {
    public static final Gson GSON = new GsonBuilder().registerTypeAdapter(class_2960.class, new class_2960.class_2961()).create();

    public TraitDataManager() {
        super(GSON, Walkers.MODID + "/traits");
    }

    @SuppressWarnings("unchecked")
    @Override
    protected void onApply(Map<class_2960, JsonElement> map) {
        // prevent duplicates and the registration of removed entries
        TraitRegistry.clearAll();
        TraitRegistry.registerDefault();

        for (Map.Entry<class_2960, JsonElement> mapEntry : map.entrySet()) {
            TraitList traitList = traitListFromJson(mapEntry.getValue().getAsJsonObject());

            if (!traitList.isEmpty()) {
                if (traitList.requiredMod() == null || traitList.requiredMod().isBlank() || PlatformData.isModLoaded(traitList.requiredMod())) {
                    // entity types
                    for (class_1299<class_1309> entityType : traitList.entityTypes()) {
                        TraitRegistry.registerByType(entityType, traitList.traitList().stream().map(trait -> (ShapeTrait<class_1309>) trait).toList());
                    }

                    if (!traitList.entityTypes().isEmpty()) {
                        logRegistration(traitList.entityTypes(), traitList.traitList());
                    }

                    // entity tags
                    for (class_6862<class_1299<?>> entityTag : traitList.entityTags()) {
                        TraitRegistry.registerByTag(entityTag, traitList.traitList().stream().map(trait -> (ShapeTrait<class_1309>) trait).toList());
                    }

                    if (!traitList.entityTags().isEmpty()) {
                        logRegistration(traitList.entityTags(), traitList.traitList());
                    }
                }
            }
        }
    }

    private static void logRegistration(Object key, List<ShapeTrait<?>> traitList) {
        Walkers.LOGGER.info("{}: {} registered for {}", TraitDataManager.class.getSimpleName(), key, traitList.stream().map(trait -> trait.getClass().getSimpleName()).toArray(String[]::new));
    }

    public static Codec<TraitList> TRAIT_LIST_CODEC = RecordCodecBuilder.create((instance) -> instance.group(Codec.STRING.optionalFieldOf("required_mod", "").forGetter(TraitList::requiredMod), Codec.list(class_2960.field_25139).optionalFieldOf("entity_types", new ArrayList<>()).forGetter(TraitList::entityTypeKeys), Codec.list(class_2960.field_25139).optionalFieldOf("entity_tags", new ArrayList<>()).forGetter(TraitList::entityTagKeys), Codec.list(TraitRegistry.getTraitCodec()).fieldOf("traits").forGetter(TraitList::traitList)).apply(instance, instance.stable(TraitList::new)));

    //#if MC>=1205
    protected TraitList traitListFromJson(JsonObject json) {
        return TRAIT_LIST_CODEC.parse(JsonOps.INSTANCE, json).getOrThrow(msg -> {
            throw new JsonParseException(msg);
        });
    }
    //#else
    //$$ protected TraitList traitListFromJson(JsonObject json) {
    //$$     return TRAIT_LIST_CODEC.parse(JsonOps.INSTANCE, json).getOrThrow(false, msg -> {
    //$$         throw new JsonParseException(msg);
    //$$     });
    //$$ }
    //#endif

    @SuppressWarnings("unused")
    public record TraitList(String requiredMod, List<class_2960> entityTypeKeys,
                            List<class_2960> entityTagKeys, List<ShapeTrait<?>> traitList) {

        public TraitList(List<class_1299<?>> entityTypeKeys, List<class_6862<class_1299<?>>> entityTagKeys, List<ShapeTrait<?>> traitList, String requiredMod) {
            this(requiredMod, entityTypeKeys.stream().map(class_1299::method_5890).toList(), entityTagKeys.stream().map(class_6862::comp_327).toList(), traitList);
        }

        @SuppressWarnings("unchecked")
        public List<class_1299<class_1309>> entityTypes() {
            return entityTypeKeys.stream().filter(Walkers.getEntityTypeRegistry()::method_10250).map(type -> (class_1299<class_1309>) Walkers.getEntityTypeRegistry().method_10223(type)).toList();
        }

        public List<class_6862<class_1299<?>>> entityTags() {
            return entityTagKeys().stream().map(tag -> class_6862.method_40092(Walkers.getEntityTypeRegistry().method_30517(), tag)).toList();
        }

        public boolean isEmpty() {
            return (entityTypeKeys().isEmpty() && entityTagKeys().isEmpty()) || traitList().isEmpty();
        }
    }
}
