package tocraft.walkers.api;

import net.minecraft.class_1269;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_3222;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import tocraft.craftedcore.network.ModernNetworking;
import tocraft.walkers.api.blacklist.EntityBlacklist;
import tocraft.walkers.api.events.ShapeEvents;
import tocraft.walkers.impl.PlayerDataProvider;
import tocraft.walkers.network.NetworkHandler;

public class PlayerShape {

    /**
     * Returns the shape associated with the {@link class_1657} this component is attached to.
     *
     * <p>Note that this method may return null, which represents "no shape."
     *
     * @return the current {@link class_1309} shape associated with this component's player owner, or null if they have no shape equipped
     */
    @Nullable
    public static class_1309 getCurrentShape(class_1657 player) {
        return ((PlayerDataProvider) player).walkers$getCurrentShape();
    }

    /**
     * Sets the shape of the specified player.
     *
     * <p>Setting a shape refreshes the player's dimensions/hitbox, and toggles flight capabilities depending on the entity.
     * To clear this component's shape, pass null.
     *
     * @param entity {@link class_1309} new shape for this component, or null to clear
     */
    public static boolean updateShapes(class_3222 player, @Nullable class_1309 entity) {
        if (entity != null && EntityBlacklist.isBlacklisted(entity.method_5864())) {
            return false;
        }

        class_1269 result = ShapeEvents.SWAP_SHAPE.invoke().swap(player, entity);
        if (result == class_1269.field_5814) {
            return false;
        }

        ((PlayerDataProvider) player).walkers$updateShapes(entity);

        return true;
    }

    @ApiStatus.Internal
    public static void sync(class_3222 player) {
        sync(player, player);
    }

    @ApiStatus.Internal
    public static void sync(class_3222 changed, class_3222 packetTarget) {
        class_2487 data = new class_2487();
        class_2487 entityTag = new class_2487();

        // serialize current shape data to tag if it exists
        class_1309 shape = getCurrentShape(changed);
        if (shape != null) {
            shape.method_5647(entityTag);
        }

        // put entity type ID under the key "id", or "minecraft:empty" if no shape is equipped (or the shape entity type is invalid)
        data.method_25927("uuid", changed.method_5667());
        data.method_10582("type", shape == null ? "minecraft:empty" : class_1299.method_5890(shape.method_5864()).toString());
        data.method_10566("entity_tag", entityTag);
        ModernNetworking.sendToPlayer(packetTarget, NetworkHandler.SHAPE_SYNC, data);
    }
}
