package tocraft.walkers.ability.impl.generic;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import tocraft.craftedcore.patched.CRegistries;
import tocraft.craftedcore.patched.Identifier;
import tocraft.walkers.Walkers;
import tocraft.walkers.ability.GenericShapeAbility;

import java.util.Objects;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2960;

public class GetItemAbility<T extends class_1309> extends GenericShapeAbility<T> {
    private final class_1799 itemStack;

    public GetItemAbility(class_1799 itemStack) {
       this.itemStack = itemStack;
    }

    public static final class_2960 ID = Walkers.id("get_item");
    @SuppressWarnings("unchecked")
    public static final MapCodec<GetItemAbility<?>> CODEC = RecordCodecBuilder.mapCodec((instance) -> instance.group(
            class_2960.field_25139.fieldOf("item").forGetter(o -> ((class_2378<class_1792>) CRegistries.getRegistry(Identifier.parse("item"))).method_10221(o.itemStack.method_7909())),
            Codec.INT.optionalFieldOf("amount", 1).forGetter(o -> o.itemStack.method_7947())
    ).apply(instance, instance.stable((item, amount) -> new GetItemAbility<>(new class_1799(Objects.requireNonNull(((class_2378<class_1792>) CRegistries.getRegistry(Identifier.parse("item"))).method_10223(item)), amount)))));

    @Override
    public void onUse(class_1657 player, T shape, class_1937 world) {
        player.method_31548().method_7394(itemStack);
    }

    @Override
    public class_1792 getIcon() {
        return itemStack.method_7909();
    }

    @Override
    public int getDefaultCooldown() {
        return 600;
    }

    @Override
    public class_2960 getId() {
        return ID;
    }

    @Override
    public MapCodec<? extends GenericShapeAbility<?>> codec() {
        return CODEC;
    }
}
