package tocraft.walkers.ability;

import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import tocraft.craftedcore.patched.CEntity;
import tocraft.walkers.Walkers;

@SuppressWarnings("resource")
public abstract class ShapeAbility<E extends class_1309> {
    abstract public class_2960 getId();

    /**
     * Defines the use action of this ability. Implementers can assume the ability checks, such as cool-downs, have successfully passed.
     *
     * @param player player using the ability
     * @param shape  current shape of the player
     * @param world  world the player is residing in
     */
    abstract public void onUse(class_1657 player, E shape, class_1937 world);

    /**
     * @return cooldown of this ability, in ticks, after it is used.
     */
    public int getCooldown(E entity) {
        String id = class_1299.method_5890(entity.method_5864()).toString();

        // put default cool-down into config if it's not already present
        if (!CEntity.level(entity).method_8608() && !Walkers.CONFIG.abilityCooldownMap.containsKey(id)) {
            Walkers.CONFIG.abilityCooldownMap.put(id, this.getDefaultCooldown());
            Walkers.CONFIG.save();
        }

        return Walkers.CONFIG.abilityCooldownMap.getOrDefault(id, getDefaultCooldown());
    }

    public int getDefaultCooldown() {
        return 20;
    }

    abstract public class_1792 getIcon();
}
