package tocraft.walkers.ability;

import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_310;
import net.minecraft.class_746;
import tocraft.craftedcore.event.client.RenderEvents;
import tocraft.craftedcore.gui.TimerOverlayRenderer;
import tocraft.walkers.api.PlayerAbilities;
import tocraft.walkers.api.PlayerShape;

public class AbilityOverlayRenderer {

    public static void register() {
        RenderEvents.HUD_RENDERING.register((matrices, delta) -> {
            class_310 client = class_310.method_1551();
            class_746 player = client.field_1724;
            class_1309 shape = PlayerShape.getCurrentShape(player);

            if (shape == null) {
                return;
            }

            ShapeAbility<class_1309> shapeAbility = AbilityRegistry.get(shape);

            if (player != null && shapeAbility != null) {
                class_1792 icon = shapeAbility.getIcon();
                if (icon != null) {
                    TimerOverlayRenderer.register(matrices, PlayerAbilities.getCooldown(player), shapeAbility.getCooldown(shape), icon);
                }
            }
        });
    }
}
